/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.handshake;

import java.nio.ByteBuffer;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.alert.DecodeErrorException;
import tech.kwik.agent15.handshake.HandshakeMessage;
import tech.kwik.agent15.log.Logger;

public class FinishedMessage
extends HandshakeMessage {
    private byte[] verifyData;
    private byte[] raw;

    public FinishedMessage(byte[] hmac) {
        this.verifyData = hmac;
        this.serialize();
    }

    public FinishedMessage() {
    }

    @Override
    public TlsConstants.HandshakeType getType() {
        return TlsConstants.HandshakeType.finished;
    }

    public FinishedMessage parse(ByteBuffer buffer, int length) throws DecodeErrorException {
        Logger.debug("Got Finished message (" + length + " bytes)");
        buffer.mark();
        int remainingLength = this.parseHandshakeHeader(buffer, TlsConstants.HandshakeType.finished, 36);
        this.verifyData = new byte[remainingLength];
        buffer.get(this.verifyData);
        buffer.reset();
        this.raw = new byte[length];
        buffer.get(this.raw);
        return this;
    }

    private void serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(4 + this.verifyData.length);
        buffer.putInt(TlsConstants.HandshakeType.finished.value << 24 | this.verifyData.length);
        buffer.put(this.verifyData);
        this.raw = buffer.array();
    }

    @Override
    public byte[] getBytes() {
        return this.raw;
    }

    public byte[] getVerifyData() {
        return this.verifyData;
    }
}

