/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.extension;

import java.nio.ByteBuffer;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.alert.DecodeErrorException;
import tech.kwik.agent15.extension.PreSharedKeyExtension;

public class ServerPreSharedKeyExtension
extends PreSharedKeyExtension {
    private int selectedIdentity;

    public ServerPreSharedKeyExtension(int selectedIdentity) {
        this.selectedIdentity = selectedIdentity;
    }

    public ServerPreSharedKeyExtension() {
    }

    public ServerPreSharedKeyExtension parse(ByteBuffer buffer) throws DecodeErrorException {
        this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.pre_shared_key, 2);
        this.selectedIdentity = buffer.getShort();
        return this;
    }

    @Override
    public byte[] getBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(6);
        buffer.putShort(TlsConstants.ExtensionType.pre_shared_key.value);
        buffer.putShort((short)2);
        buffer.putShort((short)this.selectedIdentity);
        return buffer.array();
    }

    public int getSelectedIdentity() {
        return this.selectedIdentity;
    }
}

