/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.handshake;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TlsProtocolException;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.extension.Extension;
import net.luminis.tls.extension.ExtensionParser;
import net.luminis.tls.handshake.HandshakeMessage;

public class EncryptedExtensions
extends HandshakeMessage {
    private static final int MINIMAL_MESSAGE_LENGTH = 6;
    private List<Extension> extensions;
    private byte[] raw;

    public EncryptedExtensions() {
        this.extensions = Collections.emptyList();
        this.serialize();
    }

    public EncryptedExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        this.serialize();
    }

    @Override
    public TlsConstants.HandshakeType getType() {
        return TlsConstants.HandshakeType.encrypted_extensions;
    }

    private void serialize() {
        List<byte[]> extensionBytes = this.extensions.stream().map(extension -> extension.getBytes()).collect(Collectors.toList());
        int extensionsSize = extensionBytes.stream().mapToInt(data -> ((byte[])data).length).sum();
        this.raw = new byte[6 + extensionsSize];
        ByteBuffer buffer = ByteBuffer.wrap(this.raw);
        buffer.putInt(0x8000000 | 2 + extensionsSize);
        buffer.putShort((short)extensionsSize);
        extensionBytes.forEach(bytes -> buffer.put((byte[])bytes));
    }

    public EncryptedExtensions parse(ByteBuffer buffer, int length) throws TlsProtocolException {
        return this.parse(buffer, length, null);
    }

    public EncryptedExtensions parse(ByteBuffer buffer, int length, ExtensionParser customExtensionParser) throws TlsProtocolException {
        if (buffer.remaining() < 6) {
            throw new DecodeErrorException("Message too short");
        }
        int start = buffer.position();
        int msgLength = buffer.getInt() & 0xFFFFFF;
        if (buffer.remaining() < msgLength || msgLength < 2) {
            throw new DecodeErrorException("Incorrect message length");
        }
        this.extensions = EncryptedExtensions.parseExtensions(buffer, TlsConstants.HandshakeType.server_hello, customExtensionParser);
        buffer.position(start);
        this.raw = new byte[length];
        buffer.mark();
        buffer.get(this.raw);
        return this;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    public byte[] getBytes() {
        return this.raw;
    }
}

