/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.extension;

import java.nio.ByteBuffer;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.extension.Extension;

public class UnknownExtension
extends Extension {
    private byte[] data;
    private int type;

    public UnknownExtension parse(ByteBuffer buffer) throws DecodeErrorException {
        if (buffer.remaining() < 4) {
            throw new DecodeErrorException("Extension must be at least 4 bytes long");
        }
        buffer.mark();
        this.type = buffer.getShort() & 0xFFFF;
        int length = buffer.getShort() & 0xFFFF;
        if (buffer.remaining() < length) {
            throw new DecodeErrorException("Invalid extension length");
        }
        buffer.reset();
        this.data = new byte[4 + length];
        buffer.get(this.data);
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public byte[] getBytes() {
        return new byte[0];
    }
}

