/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.engine.impl;

import java.security.SecureRandom;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.engine.TlsSession;
import net.luminis.tls.engine.TlsSessionRegistry;
import net.luminis.tls.engine.impl.TlsState;
import net.luminis.tls.extension.ClientHelloPreSharedKeyExtension;
import net.luminis.tls.handshake.NewSessionTicketMessage;

public class TlsSessionRegistryImpl
implements TlsSessionRegistry {
    private static final int DEFAULT_TICKET_LIFETIME_HOURS = 24;
    private static final int DEFAULT_TICKET_LENGTH = 16;
    private Random randomGenerator = new SecureRandom();
    private Map<BytesKey, Session> sessions = new ConcurrentHashMap<BytesKey, Session>();
    private int ticketLifeTimeInSeconds = (int)TimeUnit.HOURS.toSeconds(24L);
    private volatile boolean closed;
    private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();

    public TlsSessionRegistryImpl() {
        this.scheduledExecutorService.scheduleAtFixedRate(this::cleanupExpiredPsks, 1L, 1L, TimeUnit.MINUTES);
    }

    public TlsSessionRegistryImpl(int ticketLifeTimeInSeconds) {
        this();
        this.ticketLifeTimeInSeconds = ticketLifeTimeInSeconds;
    }

    @Override
    public NewSessionTicketMessage createNewSessionTicketMessage(byte ticketNonce, TlsConstants.CipherSuite cipher, TlsState tlsState, String applicationProtocol) {
        return this.createNewSessionTicketMessage(ticketNonce, cipher, tlsState, applicationProtocol, null, null);
    }

    @Override
    public NewSessionTicketMessage createNewSessionTicketMessage(byte ticketNonce, TlsConstants.CipherSuite cipher, TlsState tlsState, String applicationProtocol, Long maxEarlyDataSize, byte[] data) {
        if (!this.closed) {
            byte[] psk = tlsState.computePSK(new byte[]{ticketNonce});
            long ageAdd = this.randomGenerator.nextLong();
            byte[] ticketId = new byte[16];
            this.randomGenerator.nextBytes(ticketId);
            Instant expiry = Instant.now().plusMillis(TimeUnit.SECONDS.toMillis(this.ticketLifeTimeInSeconds));
            this.sessions.put(new BytesKey(ticketId), new Session(ticketId, ticketNonce, ageAdd, psk, cipher, Instant.now(), expiry, applicationProtocol, data));
            if (maxEarlyDataSize != null) {
                return new NewSessionTicketMessage(this.ticketLifeTimeInSeconds, ageAdd, new byte[]{ticketNonce}, ticketId, maxEarlyDataSize);
            }
            return new NewSessionTicketMessage(this.ticketLifeTimeInSeconds, ageAdd, new byte[]{ticketNonce}, ticketId);
        }
        return null;
    }

    @Override
    public Integer selectIdentity(List<ClientHelloPreSharedKeyExtension.PskIdentity> identities, TlsConstants.CipherSuite cipher) {
        for (int i = 0; i < identities.size(); ++i) {
            BytesKey key = new BytesKey(identities.get(i).getIdentity());
            Session candidateSession = this.sessions.get(key);
            if (candidateSession == null || !candidateSession.expiry.isAfter(Instant.now()) || candidateSession.cipher != cipher) continue;
            return i;
        }
        return null;
    }

    @Override
    public TlsSession useSession(ClientHelloPreSharedKeyExtension.PskIdentity pskIdentity) {
        return this.sessions.remove(new BytesKey(pskIdentity.getIdentity()));
    }

    @Override
    public byte[] peekSessionData(ClientHelloPreSharedKeyExtension.PskIdentity pskIdentity) {
        if (this.sessions.containsKey(new BytesKey(pskIdentity.getIdentity()))) {
            return this.sessions.get(new BytesKey(pskIdentity.getIdentity())).getData();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void shutdown() {
        this.closed = true;
        this.scheduledExecutorService.shutdown();
        this.sessions.clear();
    }

    void cleanupExpiredPsks() {
        Instant now = Instant.now();
        List<BytesKey> expired = this.sessions.entrySet().stream().filter(entry -> ((Session)entry.getValue()).expiry.isBefore(now)).map(entry -> (BytesKey)entry.getKey()).collect(Collectors.toList());
        expired.forEach(key -> this.sessions.remove(key));
    }

    private class BytesKey {
        private final byte[] data;

        public BytesKey(byte[] data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BytesKey other = (BytesKey)o;
            return Arrays.equals(this.data, other.data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }

    private class Session
    implements TlsSession {
        final byte[] ticketId;
        final byte ticketNonce;
        final long addAdd;
        final byte[] psk;
        final TlsConstants.CipherSuite cipher;
        final Instant created;
        private final Instant expiry;
        final String applicationProtocol;
        private final byte[] data;

        public Session(byte[] ticketId, byte ticketNonce, long addAdd, byte[] psk, TlsConstants.CipherSuite cipher, Instant created, Instant expiry, String applicationProtocol, byte[] data) {
            this.ticketId = ticketId;
            this.ticketNonce = ticketNonce;
            this.addAdd = addAdd;
            this.psk = psk;
            this.cipher = cipher;
            this.created = created;
            this.expiry = expiry;
            this.applicationProtocol = applicationProtocol;
            this.data = data;
        }

        @Override
        public byte[] getPsk() {
            return this.psk;
        }

        @Override
        public String getApplicationLayerProtocol() {
            return this.applicationProtocol;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }
    }
}

