/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.engine;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import net.luminis.tls.NewSessionTicket;
import net.luminis.tls.ProtectionKeysType;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TlsProtocolException;
import net.luminis.tls.alert.ErrorAlert;
import net.luminis.tls.alert.IllegalParameterAlert;
import net.luminis.tls.alert.MissingExtensionAlert;
import net.luminis.tls.alert.UnexpectedMessageAlert;
import net.luminis.tls.engine.CertificateWithPrivateKey;
import net.luminis.tls.engine.HostnameVerifier;
import net.luminis.tls.engine.TlsEngine;
import net.luminis.tls.extension.Extension;
import net.luminis.tls.handshake.CertificateMessage;
import net.luminis.tls.handshake.CertificateRequestMessage;
import net.luminis.tls.handshake.CertificateVerifyMessage;
import net.luminis.tls.handshake.EncryptedExtensions;
import net.luminis.tls.handshake.FinishedMessage;
import net.luminis.tls.handshake.NewSessionTicketMessage;
import net.luminis.tls.handshake.ServerHello;

public interface TlsClientEngine
extends TlsEngine {
    public void setServerName(String var1);

    public void addSupportedCiphers(List<TlsConstants.CipherSuite> var1);

    public void add(Extension var1);

    public void addExtensions(List<Extension> var1);

    public void setTrustManager(X509TrustManager var1);

    public void setHostnameVerifier(HostnameVerifier var1);

    public void setNewSessionTicket(NewSessionTicket var1);

    public void setClientCertificateCallback(Function<List<X500Principal>, CertificateWithPrivateKey> var1);

    public void startHandshake() throws IOException;

    public void startHandshake(TlsConstants.NamedGroup var1) throws IOException;

    public void startHandshake(TlsConstants.NamedGroup var1, List<TlsConstants.SignatureScheme> var2) throws IOException;

    public boolean handshakeFinished();

    public TlsConstants.CipherSuite getSelectedCipher();

    public List<NewSessionTicket> getNewSessionTickets();

    public List<X509Certificate> getServerCertificateChain();

    public void setCompatibilityMode(boolean var1);

    @Override
    public void received(ServerHello var1, ProtectionKeysType var2) throws MissingExtensionAlert, IllegalParameterAlert;

    @Override
    public void received(EncryptedExtensions var1, ProtectionKeysType var2) throws TlsProtocolException;

    @Override
    public void received(CertificateMessage var1, ProtectionKeysType var2) throws TlsProtocolException;

    @Override
    public void received(CertificateVerifyMessage var1, ProtectionKeysType var2) throws TlsProtocolException;

    @Override
    public void received(FinishedMessage var1, ProtectionKeysType var2) throws ErrorAlert, IOException;

    @Override
    public void received(NewSessionTicketMessage var1, ProtectionKeysType var2) throws UnexpectedMessageAlert;

    @Override
    public void received(CertificateRequestMessage var1, ProtectionKeysType var2) throws TlsProtocolException, IOException;
}

