/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.extension;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.extension.Extension;

public class ServerNameExtension
extends Extension {
    private String serverName;

    public ServerNameExtension(String serverName) {
        this.serverName = serverName;
    }

    public ServerNameExtension(ByteBuffer buffer) throws DecodeErrorException {
        int extensionDataLength = this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.server_name, 0);
        if (extensionDataLength > 0) {
            int remainingListLength;
            int read;
            if (extensionDataLength < 2) {
                throw new DecodeErrorException("incorrect extension length");
            }
            int serverNameListLength = buffer.getShort();
            if (extensionDataLength != serverNameListLength + 2) {
                throw new DecodeErrorException("inconsistent length");
            }
            for (remainingListLength = serverNameListLength; remainingListLength > 0; remainingListLength -= read) {
                read = this.parseServerName(buffer);
            }
            if (remainingListLength < 0) {
                throw new DecodeErrorException("inconsistent length");
            }
        } else {
            this.serverName = null;
        }
    }

    private int parseServerName(ByteBuffer buffer) throws DecodeErrorException {
        this.checkMinRemaining(buffer, 1);
        byte nameType = buffer.get();
        switch (nameType) {
            case 0: {
                this.checkMinRemaining(buffer, 2);
                int hostNameLength = buffer.getShort() & 0xFFFF;
                this.checkMinRemaining(buffer, hostNameLength);
                byte[] hostNameBytes = new byte[hostNameLength];
                buffer.get(hostNameBytes);
                this.serverName = new String(hostNameBytes, Charset.forName("ASCII"));
                return 3 + hostNameLength;
            }
        }
        this.checkMinRemaining(buffer, 2);
        int dataLength = buffer.getShort() & 0xFFFF;
        this.checkMinRemaining(buffer, dataLength);
        if (dataLength > buffer.remaining()) {
            throw new DecodeErrorException("extension underflow");
        }
        buffer.get(new byte[dataLength]);
        return 3 + dataLength;
    }

    @Override
    public byte[] getBytes() {
        short hostnameLength = (short)this.serverName.length();
        short extensionLength = (short)(hostnameLength + 2 + 1 + 2);
        ByteBuffer buffer = ByteBuffer.allocate(4 + extensionLength);
        buffer.putShort(TlsConstants.ExtensionType.server_name.value);
        buffer.putShort(extensionLength);
        buffer.putShort((short)(hostnameLength + 1 + 2));
        buffer.put((byte)0);
        buffer.putShort(hostnameLength);
        buffer.put(this.serverName.getBytes(Charset.forName("ASCII")));
        return buffer.array();
    }

    public String getHostName() {
        return this.serverName;
    }

    private void checkMinRemaining(Buffer buffer, int min) throws DecodeErrorException {
        if (buffer.remaining() < min) {
            throw new DecodeErrorException("extension underflow");
        }
    }
}

