/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.harmonysoft.oss.common.collection.CollectionUtil;
import tech.harmonysoft.oss.common.string.util.StringUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00050\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0001H\u0002J*\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tJ\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f2\u0006\u0010\r\u001a\u00020\u0001J\u0018\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0001J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0013H\u0002J&\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0010\u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\t\u00a8\u0006\u001c"}, d2={"Ltech/harmonysoft/oss/common/collection/CollectionUtil;", "", "()V", "flatten", "", "Lkotlin/Pair;", "", "path", "value", "", "data", "getArrayIterator", "", "array", "maybeGetIterator", "collectionOrArray", "merge", "", "from", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;", "to", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$ArrayData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$MapData;", "replaceDataHolders", "unflatten", "key", "input", "Data", "harmonysoft-common"})
@SourceDebugExtension(value={"SMAP\nCollectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionUtil.kt\ntech/harmonysoft/oss/common/collection/CollectionUtil\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,264:1\n76#2:265\n96#2,5:266\n1360#3:271\n1446#3,5:272\n1238#3,4:279\n1045#3:283\n1549#3:284\n1620#3,3:285\n453#4:277\n403#4:278\n*S KotlinDebug\n*F\n+ 1 CollectionUtil.kt\ntech/harmonysoft/oss/common/collection/CollectionUtil\n*L\n42#1:265\n42#1:266,5\n51#1:271\n51#1:272,5\n155#1:279,4\n156#1:283\n156#1:284\n156#1:285,3\n155#1:277\n155#1:278\n*E\n"})
public final class CollectionUtil {
    @NotNull
    public static final CollectionUtil INSTANCE = new CollectionUtil();

    private CollectionUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> flatten(@NotNull Map<String, ? extends Object> data) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Map<String, ? extends Object> $this$flatMap$iv = data;
        boolean $i$f$flatMap = false;
        Map<String, ? extends Object> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            block4: {
                block3: {
                    Map.Entry element$iv$iv;
                    Map.Entry entry = element$iv$iv = iterator.next();
                    boolean bl = false;
                    String key = (String)entry.getKey();
                    Object value2 = entry.getValue();
                    object = value2;
                    if (object == null) break block3;
                    Object it = object;
                    boolean bl2 = false;
                    Collection<Pair<String, Object>> collection = INSTANCE.flatten(key, it);
                    object = collection;
                    if (collection != null) break block4;
                }
                object = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = (Iterable)object;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<Pair<String, Object>> flatten(String path, Object value2) {
        Collection collection;
        block12: {
            block13: {
                Object object;
                block9: {
                    void $this$flatMapTo$iv$iv;
                    object = value2;
                    if (!(object instanceof Map)) break block9;
                    Iterable $this$flatMap$iv = ((Map)value2).entrySet();
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        Object object2;
                        block11: {
                            block10: {
                                Map.Entry entry = (Map.Entry)element$iv$iv;
                                boolean bl = false;
                                Object k = entry.getKey();
                                Object v = entry.getValue();
                                object2 = v;
                                if (object2 == null) break block10;
                                Object it = object2;
                                boolean bl2 = false;
                                Collection<Pair<String, Object>> collection2 = INSTANCE.flatten(path + "." + k, v);
                                object2 = collection2;
                                if (collection2 != null) break block11;
                            }
                            object2 = CollectionsKt.emptyList();
                        }
                        Iterable list$iv$iv = (Iterable)object2;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    collection = (List)destination$iv$iv;
                    break block12;
                }
                if (!(object instanceof List)) break block13;
                Iterable iterable = (Iterable)value2;
                Collection collection3 = new ArrayList();
                int n = 0;
                for (Object t : iterable) {
                    Collection<Pair<String, Object>> collection4;
                    block15: {
                        block14: {
                            void v;
                            int n2;
                            if ((n2 = n++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            Object list$iv$iv = t;
                            int index = n2;
                            boolean bl = false;
                            collection4 = v;
                            if (collection4 == null) break block14;
                            void it = collection4;
                            boolean bl3 = false;
                            Collection<Pair<String, Object>> collection5 = INSTANCE.flatten(path + "[" + index + "]", it);
                            collection4 = collection5;
                            if (collection5 != null) break block15;
                        }
                        collection4 = CollectionsKt.emptyList();
                    }
                    CollectionsKt.addAll((Collection)collection3, (Iterable)collection4);
                }
                collection = (List)collection3;
                break block12;
            }
            collection = CollectionsKt.listOf((Object)TuplesKt.to((Object)path, (Object)value2));
        }
        return collection;
    }

    @NotNull
    public final Map<String, Object> unflatten(@NotNull Map<String, ?> input) {
        Object object;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                Object result = null;
                for (Map.Entry<String, ?> entry : input.entrySet()) {
                    Unit unit;
                    String key = entry.getKey();
                    Object value2 = entry.getValue();
                    Data data = this.unflatten(key, new Data.LeafData(value2));
                    if (result != null) {
                        Map it;
                        boolean bl = false;
                        INSTANCE.merge(data, (Data)((Object)it));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) continue;
                    CollectionUtil $this$unflatten_u24lambda_u247 = this;
                    boolean bl = false;
                    result = data;
                }
                object = result;
                if (object == null) break block6;
                Map it = object;
                boolean bl = false;
                Object object2 = INSTANCE.replaceDataHolders((Data)((Object)it));
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
                Map map = (Map)object2;
                object = map;
                if (map != null) break block7;
            }
            object = MapsKt.emptyMap();
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void merge(Data from, Data to) {
        Data data = from;
        if (data instanceof Data.MapData) {
            if (!(to instanceof Data.MapData)) throw new IllegalArgumentException("wrong data setup - there are values of type " + Reflection.getOrCreateKotlinClass(from.getClass()).getSimpleName() + " and " + Reflection.getOrCreateKotlinClass(to.getClass()).getSimpleName());
            this.merge((Data.MapData)from, (Data.MapData)to);
            return;
        } else if (data instanceof Data.ArrayData) {
            if (!(to instanceof Data.ArrayData)) throw new IllegalArgumentException("wrong data setup - there are values of type " + Reflection.getOrCreateKotlinClass(from.getClass()).getSimpleName() + " and " + Reflection.getOrCreateKotlinClass(to.getClass()).getSimpleName());
            this.merge((Data.ArrayData)from, (Data.ArrayData)to);
            return;
        } else {
            if (!(data instanceof Data.LeafData)) return;
            throw new IllegalArgumentException("wrong data setup - duplicate leaf value '" + ((Data.LeafData)from).getValue() + "' vs " + to);
        }
    }

    private final void merge(Data.MapData from, Data.MapData to) {
        for (Map.Entry<String, Data> entry : from.getData().entrySet()) {
            String key = entry.getKey();
            Data value2 = entry.getValue();
            Data existingValue = to.getData().get(key);
            if (existingValue == null) {
                to.getData().put(key, value2);
                continue;
            }
            this.merge(value2, existingValue);
        }
    }

    private final void merge(Data.ArrayData from, Data.ArrayData to) {
        for (Map.Entry<Integer, Data> entry : from.getByIndex().entrySet()) {
            int index = ((Number)entry.getKey()).intValue();
            Data value2 = entry.getValue();
            Data existingValue = to.getByIndex().get(index);
            if (existingValue == null) {
                Integer n = index;
                to.getByIndex().put(n, value2);
                continue;
            }
            this.merge(value2, existingValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object replaceDataHolders(Data from) {
        Object object;
        Data data = from;
        if (data instanceof Data.MapData) {
            void $this$mapValuesTo$iv$iv;
            Map<String, Data> $this$mapValues$iv = ((Data.MapData)from).getData();
            boolean $i$f$mapValues = false;
            Map<String, Data> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Data v = (Data)entry2.getValue();
                Object object2 = INSTANCE.replaceDataHolders(v);
                map3.put(k, object2);
            }
            object = destination$iv$iv;
        } else if (data instanceof Data.ArrayData) {
            void $this$mapTo$iv$iv;
            Iterable $this$sortedBy$iv = ((Data.ArrayData)from).getByIndex().entrySet();
            boolean $i$f$sortedBy = false;
            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getKey();
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
                }
            });
            boolean $i$f$map = false;
            Iterable $this$mapValuesTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Map.Entry entry = (Map.Entry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(INSTANCE.replaceDataHolders((Data)it.getValue()));
            }
            object = (List)destination$iv$iv;
        } else if (data instanceof Data.LeafData) {
            object = ((Data.LeafData)from).getValue();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    private final Data unflatten(String key, Data value2) {
        String currentKey = key;
        Data currentValue = value2;
        while (StringUtilKt.isNotBlankEffective(currentKey)) {
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)currentKey, (char)'.', (int)0, (boolean)false, (int)6, null);
            int bracketIndex = StringsKt.lastIndexOf$default((CharSequence)currentKey, (char)']', (int)0, (boolean)false, (int)6, null);
            if (dotIndex < 0 && bracketIndex < 0) {
                currentValue = new Data.MapData(currentKey, currentValue);
                break;
            }
            if (dotIndex >= 0 && bracketIndex < dotIndex) {
                String subKey;
                Intrinsics.checkNotNullExpressionValue((Object)currentKey.substring(dotIndex + 1), (String)"substring(...)");
                currentValue = new Data.MapData(subKey, currentValue);
                Intrinsics.checkNotNullExpressionValue((Object)currentKey.substring(0, dotIndex), (String)"substring(...)");
                continue;
            }
            int openingBracketIndex = StringsKt.lastIndexOf$default((CharSequence)currentKey, (char)'[', (int)0, (boolean)false, (int)6, null);
            String string = currentKey.substring(openingBracketIndex + 1, bracketIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            int index = Integer.parseInt(string);
            Intrinsics.checkNotNullExpressionValue((Object)currentKey.substring(0, openingBracketIndex), (String)"substring(...)");
            currentValue = new Data.ArrayData(index, currentValue);
        }
        return currentValue;
    }

    @Nullable
    public final Iterator<Object> maybeGetIterator(@NotNull Object collectionOrArray) {
        Intrinsics.checkNotNullParameter((Object)collectionOrArray, (String)"collectionOrArray");
        return collectionOrArray instanceof Collection ? ((Collection)collectionOrArray).iterator() : (collectionOrArray.getClass().isArray() ? this.getArrayIterator(collectionOrArray) : null);
    }

    @NotNull
    public final Iterator<Object> getArrayIterator(@NotNull Object array) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Object object = array;
        if (object instanceof Object[]) {
            iterator = ArrayIteratorKt.iterator((Object[])((Object[])array));
        } else if (object instanceof int[]) {
            iterator = (Iterator)ArrayIteratorsKt.iterator((int[])((int[])array));
        } else if (object instanceof long[]) {
            iterator = (Iterator)ArrayIteratorsKt.iterator((long[])((long[])array));
        } else if (object instanceof double[]) {
            iterator = (Iterator)ArrayIteratorsKt.iterator((double[])((double[])array));
        } else if (object instanceof float[]) {
            iterator = (Iterator)ArrayIteratorsKt.iterator((float[])((float[])array));
        } else if (object instanceof short[]) {
            iterator = (Iterator)ArrayIteratorsKt.iterator((short[])((short[])array));
        } else if (object instanceof char[]) {
            iterator = (Iterator)ArrayIteratorsKt.iterator((char[])((char[])array));
        } else if (object instanceof byte[]) {
            iterator = (Iterator)ArrayIteratorsKt.iterator((byte[])((byte[])array));
        } else {
            throw new IllegalArgumentException("given argument of type " + Reflection.getOrCreateKotlinClass(array.getClass()).getQualifiedName() + " is not an array (" + array + ")");
        }
        return iterator;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;", "", "ArrayData", "LeafData", "MapData", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$ArrayData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$LeafData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$MapData;", "harmonysoft-common"})
    public static sealed interface Data {

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$ArrayData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;", "index", "", "data", "(ILtech/harmonysoft/oss/common/collection/CollectionUtil$Data;)V", "byIndex", "", "getByIndex", "()Ljava/util/Map;", "toString", "", "harmonysoft-common"})
        public static final class ArrayData
        implements Data {
            @NotNull
            private final Map<Integer, Data> byIndex;

            /*
             * WARNING - void declaration
             */
            public ArrayData(int index, @NotNull Data data) {
                void $this$byIndex_u24lambda_u240;
                Map map;
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Map map2 = map = (Map)new LinkedHashMap();
                ArrayData arrayData = this;
                boolean bl = false;
                Integer n = index;
                $this$byIndex_u24lambda_u240.put(n, data);
                arrayData.byIndex = map;
            }

            @NotNull
            public final Map<Integer, Data> getByIndex() {
                return this.byIndex;
            }

            @NotNull
            public String toString() {
                return CollectionsKt.joinToString$default((Iterable)this.byIndex.entrySet(), null, (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)toString.1.INSTANCE, (int)25, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$LeafData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;", "value", "", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "toString", "", "harmonysoft-common"})
        public static final class LeafData
        implements Data {
            @Nullable
            private final Object value;

            public LeafData(@Nullable Object value2) {
                this.value = value2;
            }

            @Nullable
            public final Object getValue() {
                return this.value;
            }

            @NotNull
            public String toString() {
                return String.valueOf(this.value);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u0003H\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data$MapData;", "Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;", "key", "", "value", "(Ljava/lang/String;Ltech/harmonysoft/oss/common/collection/CollectionUtil$Data;)V", "data", "", "getData", "()Ljava/util/Map;", "toString", "harmonysoft-common"})
        public static final class MapData
        implements Data {
            @NotNull
            private final Map<String, Data> data;

            /*
             * WARNING - void declaration
             */
            public MapData(@NotNull String key, @NotNull Data value2) {
                void $this$data_u24lambda_u240;
                Map map;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Map map2 = map = (Map)new LinkedHashMap();
                MapData mapData = this;
                boolean bl = false;
                $this$data_u24lambda_u240.put(key, value2);
                mapData.data = map;
            }

            @NotNull
            public final Map<String, Data> getData() {
                return this.data;
            }

            @NotNull
            public String toString() {
                return this.data.toString();
            }
        }
    }
}

