/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.backup.file.impl;

import java.io.File;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.harmonysoft.oss.common.backup.file.FileSystemBackupService;
import tech.harmonysoft.oss.common.time.clock.ClockProvider;
import tech.harmonysoft.oss.common.time.util.DateTimeHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Named
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J6\u0010\u0016\u001a\u0004\u0018\u00010\r\"\u000e\b\u0000\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\u00182\u0006\u0010\u0013\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002H\u00170\u0010H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ltech/harmonysoft/oss/common/backup/file/impl/FileSystemBackupServiceImpl;", "Ltech/harmonysoft/oss/common/backup/file/FileSystemBackupService;", "clockProvider", "Ltech/harmonysoft/oss/common/time/clock/ClockProvider;", "dateTimeHelper", "Ltech/harmonysoft/oss/common/time/util/DateTimeHelper;", "(Ltech/harmonysoft/oss/common/time/clock/ClockProvider;Ltech/harmonysoft/oss/common/time/util/DateTimeHelper;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "backup", "", "backupDir", "Ljava/io/File;", "toBackup", "toBackupFilter", "Lkotlin/Function1;", "", "cleanOutdated", "rootDir", "ttlDays", "", "findMostRecentDirectory", "T", "", "childDirNameParser", "", "getLastAvailableBackupDir", "rootBackupDir", "ttlInDays", "prepareNewBackupDir", "harmonysoft-common"})
public final class FileSystemBackupServiceImpl
implements FileSystemBackupService {
    @NotNull
    private final ClockProvider clockProvider;
    @NotNull
    private final DateTimeHelper dateTimeHelper;
    private final Logger logger;

    public FileSystemBackupServiceImpl(@NotNull ClockProvider clockProvider, @NotNull DateTimeHelper dateTimeHelper) {
        Intrinsics.checkNotNullParameter((Object)clockProvider, (String)"clockProvider");
        Intrinsics.checkNotNullParameter((Object)dateTimeHelper, (String)"dateTimeHelper");
        this.clockProvider = clockProvider;
        this.dateTimeHelper = dateTimeHelper;
        this.logger = LoggerFactory.getLogger(FileSystemBackupServiceImpl.class);
    }

    @Override
    @NotNull
    public File prepareNewBackupDir(@NotNull File rootBackupDir) {
        File file;
        Intrinsics.checkNotNullParameter((Object)rootBackupDir, (String)"rootBackupDir");
        if (rootBackupDir.isFile()) {
            throw new IllegalArgumentException("failed to prepare new backup dir - expected " + rootBackupDir.getCanonicalPath() + " to be a backup directory but it points to a file");
        }
        Object object = this.clockProvider.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clockProvider.data");
        Clock clock = (Clock)object;
        LocalDate localDate = LocalDate.now(clock);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(clock)");
        File dateDir = new File(rootBackupDir, this.dateTimeHelper.formatDate(localDate));
        if (dateDir.isFile()) {
            throw new IllegalStateException("failed to prepare new backup dir - expected " + dateDir.getCanonicalPath() + " to be a backup directory but it points to a file");
        }
        LocalTime localTime = LocalTime.now(clock);
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"now(clock)");
        File timeDir = new File(dateDir, this.dateTimeHelper.formatTime(localTime));
        if (timeDir.isFile()) {
            throw new IllegalStateException("failed to prepare new backup dir - expected " + timeDir.getCanonicalPath() + " to be a backup directory but it points to a file");
        }
        if (timeDir.isDirectory()) {
            file = timeDir;
        } else {
            boolean created = timeDir.mkdirs();
            if (created) {
                file = timeDir;
            } else {
                throw new IllegalStateException("failed to prepare a backup dir at path " + timeDir.getCanonicalPath() + " - it doesn't exist and we failed to create it");
            }
        }
        return file;
    }

    @Override
    @Nullable
    public File getLastAvailableBackupDir(@NotNull File rootBackupDir, int ttlInDays) {
        File file;
        Intrinsics.checkNotNullParameter((Object)rootBackupDir, (String)"rootBackupDir");
        if (!rootBackupDir.isDirectory()) {
            return null;
        }
        File file2 = this.findMostRecentDirectory(rootBackupDir, (Function1)new Function1<String, LocalDate>(this){
            final /* synthetic */ FileSystemBackupServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final LocalDate invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FileSystemBackupServiceImpl.access$getDateTimeHelper$p(this.this$0).parseDate(it, "yyyy-MM-dd");
            }
        });
        if (file2 != null) {
            File dateDirectory = file2;
            boolean bl = false;
            file = this.findMostRecentDirectory(dateDirectory, (Function1)new Function1<String, LocalTime>(this){
                final /* synthetic */ FileSystemBackupServiceImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final LocalTime invoke(@NotNull String timeDirectory) {
                    Intrinsics.checkNotNullParameter((Object)timeDirectory, (String)"timeDirectory");
                    return FileSystemBackupServiceImpl.access$getDateTimeHelper$p(this.this$0).parseTime(timeDirectory, "HH:mm:ss.SSS");
                }
            });
        } else {
            file = null;
        }
        return file;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <T extends Comparable<? super T>> File findMostRecentDirectory(File rootDir, Function1<? super String, ? extends T> childDirNameParser) {
        Object v3;
        void $this$maxByOrNull$iv;
        void $this$mapNotNullTo$iv$iv;
        Pair pair = rootDir.listFiles(FileSystemBackupServiceImpl::findMostRecentDirectory$lambda-1);
        Pair pair2 = pair;
        if (pair == null) return null;
        Pair $this$mapNotNull$iv = pair2;
        boolean $i$f$mapNotNull22 = false;
        Pair pair3 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Pair it$iv$iv;
            Pair pair4;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            try {
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                pair4 = TuplesKt.to((Object)childDirNameParser.invoke((Object)string), (Object)it);
            }
            catch (Exception e) {
                this.logger.warn("Unexpected directory is found under backup dir {}", (Object)rootDir.getCanonicalPath(), (Object)e);
                pair4 = null;
            }
            if (pair4 == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $i$f$mapNotNull22 = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = maxElem$iv;
            } else {
                Pair it = (Pair)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)it.getFirst();
                do {
                    Object e$iv = iterator$iv.next();
                    Pair it2 = (Pair)e$iv;
                    $i$a$-maxByOrNull-FileSystemBackupServiceImpl$findMostRecentDirectory$3 = false;
                    Comparable v$iv = (Comparable)it2.getFirst();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = maxElem$iv;
            }
        }
        Pair pair5 = v3;
        pair2 = pair5;
        if (pair5 == null) return null;
        File file = (File)pair2.getSecond();
        return file;
    }

    @Override
    public void backup(@NotNull File backupDir, @NotNull File toBackup, @NotNull Function1<? super File, Boolean> toBackupFilter) {
        Stack<File> stack;
        boolean created;
        Intrinsics.checkNotNullParameter((Object)backupDir, (String)"backupDir");
        Intrinsics.checkNotNullParameter((Object)toBackup, (String)"toBackup");
        Intrinsics.checkNotNullParameter(toBackupFilter, (String)"toBackupFilter");
        if (!backupDir.isDirectory() && !(created = backupDir.mkdirs())) {
            this.logger.warn("Failed to backup files from '{}' to '{}' - can't create the output dir", (Object)toBackup.getCanonicalPath(), (Object)backupDir.getCanonicalPath());
            return;
        }
        Stack<File> $this$backup_u24lambda_u2d4 = stack = new Stack<File>();
        boolean bl = false;
        $this$backup_u24lambda_u2d4.push(toBackup);
        Stack<File> toProcess = stack;
        while (!((Collection)toProcess).isEmpty()) {
            File[] $this$forEach$iv;
            File file = (File)toProcess.pop();
            if (file.isFile()) {
                boolean created2;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                if (!((Boolean)toBackupFilter.invoke((Object)file)).booleanValue()) continue;
                File destination = new File(backupDir, file.getName());
                if (!destination.getParentFile().exists() && !(created2 = destination.getParentFile().mkdirs())) {
                    this.logger.warn("Failed to backup files from '{}' can't create the output dir {}", (Object)toBackup.getCanonicalPath(), (Object)backupDir.getCanonicalPath());
                    return;
                }
                FilesKt.copyTo$default((File)file, (File)destination, (boolean)true, (int)0, (int)4, null);
                this.logger.info("Backed up file {} as {}", (Object)file.getCanonicalPath(), (Object)destination.getCanonicalPath());
                continue;
            }
            if (!file.isDirectory() || Intrinsics.areEqual((Object)file, (Object)backupDir)) continue;
            if (file.listFiles() == null) continue;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                toProcess.push(it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanOutdated(@NotNull File rootDir, int ttlDays) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        if (!rootDir.isDirectory()) {
            this.logger.info("Skip cleaning backup as target dir doesn't exist ({})", (Object)rootDir.getCanonicalPath());
            return;
        }
        LocalDate firstLiveData = LocalDate.now((Clock)this.clockProvider.getData()).minusDays(ttlDays);
        File[] fileArray = rootDir.listFiles(FileSystemBackupServiceImpl::cleanOutdated$lambda-6);
        if (fileArray != null) {
            void $this$forEach$iv;
            File[] fileArray2 = fileArray;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv).length;
            for (int i = 0; i < n; ++i) {
                LocalDate localDate;
                LocalDate localDate2;
                void element$iv;
                void dir = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                try {
                    String string = dir.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dir.name");
                    localDate2 = this.dateTimeHelper.parseDate(string);
                }
                catch (Exception e) {
                    Object[] objectArray = new Object[]{dir.getName(), rootDir.getCanonicalPath(), "yyyy-MM-dd"};
                    this.logger.warn("Unexpected directory named '{}' is found in {} backup dir. It doesn't conform to pattern '{}'. Keeping it as-is, take care of it manually if necessary", objectArray);
                    localDate2 = null;
                }
                LocalDate localDate3 = localDate2;
                if (localDate3 == null) continue;
                LocalDate it = localDate = localDate3;
                boolean bl2 = false;
                LocalDate localDate4 = localDate2 = it.isBefore(firstLiveData) ? localDate : null;
                if (localDate2 == null) continue;
                it = localDate2;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
                boolean success = FilesKt.deleteRecursively((File)dir);
                if (success) {
                    this.logger.info("Cleaned outdated backup directory '{}'", (Object)dir.getCanonicalPath());
                    continue;
                }
                this.logger.warn("Failed to clean up an outdated directory '{}'. Please take care of it manually", (Object)dir.getCanonicalPath());
            }
        }
    }

    private static final boolean findMostRecentDirectory$lambda-1(File file) {
        File file2 = file;
        return file2 != null ? file2.isDirectory() : false;
    }

    private static final boolean cleanOutdated$lambda-6(File it) {
        return it.isDirectory();
    }

    public static final /* synthetic */ DateTimeHelper access$getDateTimeHelper$p(FileSystemBackupServiceImpl $this) {
        return $this.dateTimeHelper;
    }
}

