/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.data.impl;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.harmonysoft.oss.common.data.ComparisonStrategy;
import tech.harmonysoft.oss.common.type.TypeManagerContext;
import tech.harmonysoft.oss.common.type.TypeManagersHelper;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J;\u0010\b\u001a\u0004\u0018\u00010\t\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\b\u0010\u000e\u001a\u0004\u0018\u0001H\n2\b\u0010\u000f\u001a\u0004\u0018\u0001H\nH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ltech/harmonysoft/oss/common/data/impl/DefaultComparisonStrategy;", "Ltech/harmonysoft/oss/common/data/ComparisonStrategy;", "typeManagersHelper", "Ltech/harmonysoft/oss/common/type/TypeManagersHelper;", "contexts", "", "Ltech/harmonysoft/oss/common/type/TypeManagerContext;", "(Ltech/harmonysoft/oss/common/type/TypeManagersHelper;Ljava/util/Set;)V", "compare", "", "T", "", "targetType", "Lkotlin/reflect/KClass;", "first", "second", "(Lkotlin/reflect/KClass;Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Integer;", "harmonysoft-common"})
public final class DefaultComparisonStrategy
implements ComparisonStrategy {
    @NotNull
    private final TypeManagersHelper typeManagersHelper;
    @NotNull
    private final Set<TypeManagerContext> contexts;

    public DefaultComparisonStrategy(@NotNull TypeManagersHelper typeManagersHelper, @NotNull Set<TypeManagerContext> contexts) {
        Intrinsics.checkNotNullParameter((Object)typeManagersHelper, (String)"typeManagersHelper");
        Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
        this.typeManagersHelper = typeManagersHelper;
        this.contexts = contexts;
    }

    @Override
    @Nullable
    public <T> Integer compare(@NotNull KClass<T> targetType, @Nullable T first, @Nullable T second) {
        Integer n;
        Intrinsics.checkNotNullParameter(targetType, (String)"targetType");
        if (first == null && second == null) {
            n = 0;
        } else if (first != null) {
            n = this.typeManagersHelper.getTypeManager(targetType, this.contexts).compareTo(first, second);
        } else if (second != null) {
            n = ComparisonStrategy.Companion.inverse(this.typeManagersHelper.getTypeManager(targetType, this.contexts).compareTo(second, first));
        } else {
            throw new UnsupportedOperationException("I can't happen");
        }
        return n;
    }
}

