/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.time.util;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.harmonysoft.oss.common.time.clock.ClockProvider;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Named
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0007J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0007J\u0016\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0007J\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0007J\u0016\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltech/harmonysoft/oss/common/time/util/DateTimeHelper;", "", "clockProvider", "Ltech/harmonysoft/oss/common/time/clock/ClockProvider;", "(Ltech/harmonysoft/oss/common/time/clock/ClockProvider;)V", "patterns", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/time/format/DateTimeFormatter;", "formatDate", "date", "Ljava/time/LocalDate;", "pattern", "formatDateTime", "dateTime", "Ljava/time/LocalDateTime;", "formatTime", "time", "Ljava/time/LocalTime;", "getFormatter", "isWeekend", "", "Ljava/time/Instant;", "timeZone", "Ljava/time/ZoneId;", "parseDate", "raw", "parseDateTime", "parseTime", "Companion", "harmonysoft-common"})
public final class DateTimeHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClockProvider clockProvider;
    @NotNull
    private final ConcurrentHashMap<String, DateTimeFormatter> patterns;
    @NotNull
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    @NotNull
    public static final String TIME_PATTERN = "HH:mm:ss.SSS";
    @NotNull
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";

    public DateTimeHelper(@NotNull ClockProvider clockProvider) {
        Intrinsics.checkNotNullParameter((Object)clockProvider, (String)"clockProvider");
        this.clockProvider = clockProvider;
        this.patterns = new ConcurrentHashMap();
    }

    @NotNull
    public final String formatDate(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string = this.getFormatter(DATE_PATTERN).format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormatter(DATE_PATTERN).format(date)");
        return string;
    }

    @NotNull
    public final String formatDate(@NotNull LocalDate date, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = this.getFormatter(pattern).format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormatter(pattern).format(date)");
        return string;
    }

    @NotNull
    public final String formatTime(@NotNull LocalTime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        String string = this.getFormatter(TIME_PATTERN).format(time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormatter(TIME_PATTERN).format(time)");
        return string;
    }

    @NotNull
    public final String formatTime(@NotNull LocalTime time, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = this.getFormatter(pattern).format(time);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormatter(pattern).format(time)");
        return string;
    }

    @NotNull
    public final String formatDateTime(@NotNull LocalDateTime dateTime) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        String string = this.getFormatter(DATE_TIME_PATTERN).format(dateTime);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormatter(DATE_TIME_PATTERN).format(dateTime)");
        return string;
    }

    @NotNull
    public final String formatDateTime(@NotNull LocalDateTime dateTime, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        String string = this.getFormatter(pattern).format(dateTime);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFormatter(pattern).format(dateTime)");
        return string;
    }

    public final boolean isWeekend(@NotNull Instant time, @NotNull ZoneId timeZone) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        DayOfWeek dayOfWeek = DayOfWeek.from(time.atZone(timeZone));
        return dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY;
    }

    @NotNull
    public final LocalTime parseTime(@NotNull String raw) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        return this.parseTime(raw, TIME_PATTERN);
    }

    @NotNull
    public final LocalTime parseTime(@NotNull String raw, @NotNull String pattern) {
        LocalTime localTime;
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        try {
            LocalTime localTime2 = LocalTime.parse(raw, this.getFormatter(pattern));
            Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"{\n            LocalTime.\u2026atter(pattern))\n        }");
            localTime = localTime2;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse local time from '" + raw + "' using pattern '" + pattern + '\'', e);
        }
        return localTime;
    }

    @NotNull
    public final LocalDate parseDate(@NotNull String raw) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        return this.parseDate(raw, DATE_PATTERN);
    }

    @NotNull
    public final LocalDate parseDate(@NotNull String raw, @NotNull String pattern) {
        LocalDate localDate;
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        try {
            LocalDate localDate2 = LocalDate.parse(raw, this.getFormatter(pattern));
            Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"{\n            LocalDate.\u2026atter(pattern))\n        }");
            localDate = localDate2;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse local date from '" + raw + "' using pattern '" + pattern + '\'', e);
        }
        return localDate;
    }

    @NotNull
    public final LocalDateTime parseDateTime(@NotNull String raw) {
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        return this.parseDateTime(raw, DATE_TIME_PATTERN);
    }

    @NotNull
    public final LocalDateTime parseDateTime(@NotNull String raw, @NotNull String pattern) {
        LocalDateTime localDateTime;
        Intrinsics.checkNotNullParameter((Object)raw, (String)"raw");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        try {
            LocalDateTime localDateTime2 = LocalDateTime.parse(raw, this.getFormatter(pattern));
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"{\n            LocalDateT\u2026atter(pattern))\n        }");
            localDateTime = localDateTime2;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to parse local date time from '" + raw + "' using pattern '" + pattern + '\'', e);
        }
        return localDateTime;
    }

    @NotNull
    public final DateTimeFormatter getFormatter(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        DateTimeFormatter dateTimeFormatter = this.patterns.get(pattern);
        if (dateTimeFormatter == null) {
            DateTimeFormatter dateTimeFormatter2 = this.patterns.computeIfAbsent(pattern, arg_0 -> DateTimeHelper.getFormatter$lambda-0(pattern, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter2, (String)"patterns.computeIfAbsent\u2026attern(pattern)\n        }");
            dateTimeFormatter = dateTimeFormatter2;
        }
        return dateTimeFormatter;
    }

    private static final DateTimeFormatter getFormatter$lambda-0(String $pattern, String it) {
        Intrinsics.checkNotNullParameter((Object)$pattern, (String)"$pattern");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DateTimeFormatter.ofPattern($pattern);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ltech/harmonysoft/oss/common/time/util/DateTimeHelper$Companion;", "", "()V", "DATE_PATTERN", "", "DATE_TIME_PATTERN", "TIME_PATTERN", "harmonysoft-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

