/*
 * Decompiled with CFR 0.152.
 */
package com.mobile.base.phoneinfo;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Process;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import java.util.List;

public class PhoneInfoHelper {
    public static final String INSTALL_ID = "installId";
    public static final String DEFAULT_INSTALL_ID = "EE062C6D19484800111FE238F088D794";
    public static int dpi;
    public static int osv;
    public static String netType;
    public static String platform;
    public static String MAC;
    public static String IMEI;
    public static String packageName;
    public static String installId;
    public static String customerId;
    public static Application appContext;
    public static String versionName;
    public static int versionCode;
    public static boolean debuggable;
    public static int uid;
    public static String systemUserAgent;
    public static int screenWidth;
    public static int screenHeight;
    public static float density;
    public static String model;
    public static String processName;

    public static void init(Application context) {
        String _installId;
        appContext = context;
        processName = PhoneInfoHelper.getCurrentProcessName();
        SharedPreferences mshare = PreferenceManager.getDefaultSharedPreferences((Context)context);
        installId = _installId = mshare.getString(INSTALL_ID, DEFAULT_INSTALL_ID);
        try {
            PackageInfo packInfo = appContext.getPackageManager().getPackageInfo(appContext.getPackageName(), 0);
            versionName = packInfo.versionName;
            versionCode = packInfo.versionCode;
            debuggable = (packInfo.applicationInfo.flags & 2) != 0;
            uid = PhoneInfoHelper.appContext.getPackageManager().getApplicationInfo((String)PhoneInfoHelper.appContext.getPackageName(), (int)0).uid;
            systemUserAgent = System.getProperty("http.agent");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            WifiManager wifi = (WifiManager)appContext.getSystemService("wifi");
            WifiInfo info = wifi.getConnectionInfo();
            MAC = info.getMacAddress();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            IMEI = ((TelephonyManager)appContext.getSystemService("phone")).getDeviceId();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        screenHeight = displayMetrics.heightPixels;
        screenWidth = displayMetrics.widthPixels;
        dpi = displayMetrics.densityDpi;
        density = displayMetrics.density;
        model = Build.MODEL;
        osv = Build.VERSION.SDK_INT;
        netType = PhoneInfoHelper.getNetworkType(context);
        platform = Build.CPU_ABI;
    }

    public static String getNetworkType(Application context) {
        String strNetworkType = "";
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (networkInfo.getType() == 1) {
                strNetworkType = "wifi";
            } else if (networkInfo.getType() == 0) {
                String _strSubTypeName = networkInfo.getSubtypeName();
                int networkType = networkInfo.getSubtype();
                switch (networkType) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        strNetworkType = "2g";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        strNetworkType = "3g";
                        break;
                    }
                    case 13: {
                        strNetworkType = "4g";
                        break;
                    }
                    default: {
                        strNetworkType = _strSubTypeName.equalsIgnoreCase("TD-SCDMA") || _strSubTypeName.equalsIgnoreCase("WCDMA") || _strSubTypeName.equalsIgnoreCase("CDMA2000") ? "3g" : _strSubTypeName;
                    }
                }
            }
        }
        return strNetworkType;
    }

    private static String getCurrentProcessName() {
        ActivityManager am = (ActivityManager)appContext.getSystemService("activity");
        if (am == null) {
            return null;
        }
        List list = am.getRunningAppProcesses();
        int pid = Process.myPid();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (((ActivityManager.RunningAppProcessInfo)list.get((int)i)).pid != pid) continue;
                return ((ActivityManager.RunningAppProcessInfo)list.get((int)i)).processName;
            }
        }
        return null;
    }

    public static String getPhoneInfos() {
        StringBuilder sb = new StringBuilder();
        sb.append("---------- environment ----------\n").append("versionName: ").append(versionName).append("\n").append("versionCode: ").append(versionCode).append("\n").append("packageName: ").append(packageName).append("\n").append("debuggable: ").append(debuggable).append("\n").append("uid: ").append(uid).append("\n").append("systemUserAgent: ").append(systemUserAgent).append("\n").append("screenWidth: ").append(screenWidth).append("\n").append("screenHeight: ").append(screenHeight).append("\n").append("dpi: ").append(dpi).append("\n").append("density: ").append(density).append("\n").append("model: ").append(model).append("\n").append("osv: ").append(osv).append("\n").append("net: ").append(netType).append("\n").append("platform: ").append(platform).append("\n").append("installId: ").append(installId).append("\n").append("customerId: ").append(customerId).append("\n").append("appContext: ").append(appContext).append("\n").append("processName: ").append(processName).append("\n").append("MAC: ").append(MAC).append("\n").append("IMEI: ").append(IMEI).append("\n").append("---------------------------------");
        return sb.toString();
    }

    static {
        packageName = "com.ganji.android.haoche_c";
        customerId = "879";
    }
}

