/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.CompletableFuture;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;

public final class Utils {
    public static CompletableFuture<ResultOfConvertAddress> convertAddress(int ctxId, String address, AddressStringFormat outputFormat) throws EverSdkException {
        return EverSdk.async(ctxId, "utils.convert_address", new ParamsOfConvertAddress(address, outputFormat), ResultOfConvertAddress.class);
    }

    public static CompletableFuture<ResultOfGetAddressType> getAddressType(int ctxId, String address) throws EverSdkException {
        return EverSdk.async(ctxId, "utils.get_address_type", new ParamsOfGetAddressType(address), ResultOfGetAddressType.class);
    }

    public static CompletableFuture<ResultOfCalcStorageFee> calcStorageFee(int ctxId, String account, Long period) throws EverSdkException {
        return EverSdk.async(ctxId, "utils.calc_storage_fee", new ParamsOfCalcStorageFee(account, period), ResultOfCalcStorageFee.class);
    }

    public static CompletableFuture<ResultOfCompressZstd> compressZstd(int ctxId, String uncompressed, Long level) throws EverSdkException {
        return EverSdk.async(ctxId, "utils.compress_zstd", new ParamsOfCompressZstd(uncompressed, level), ResultOfCompressZstd.class);
    }

    public static CompletableFuture<ResultOfDecompressZstd> decompressZstd(int ctxId, String compressed) throws EverSdkException {
        return EverSdk.async(ctxId, "utils.decompress_zstd", new ParamsOfDecompressZstd(compressed), ResultOfDecompressZstd.class);
    }

    public record ParamsOfConvertAddress(String address, AddressStringFormat outputFormat) {
    }

    public static sealed interface AddressStringFormat {

        public record Base64(Boolean url, Boolean test, Boolean bounce) implements AddressStringFormat
        {
            @JsonProperty(value="type")
            public String type() {
                return "Base64";
            }
        }

        public record Hex() implements AddressStringFormat
        {
            @JsonProperty(value="type")
            public String type() {
                return "Hex";
            }
        }

        public record AccountId() implements AddressStringFormat
        {
            @JsonProperty(value="type")
            public String type() {
                return "AccountId";
            }
        }
    }

    public record ResultOfConvertAddress(String address) {
    }

    public record ParamsOfGetAddressType(String address) {
    }

    public record ResultOfGetAddressType(AccountAddressType addressType) {
    }

    public record ParamsOfCalcStorageFee(String account, Long period) {
    }

    public record ResultOfCalcStorageFee(String fee) {
    }

    public record ParamsOfCompressZstd(String uncompressed, Long level) {
    }

    public record ResultOfCompressZstd(String compressed) {
    }

    public record ParamsOfDecompressZstd(String compressed) {
    }

    public record ResultOfDecompressZstd(String decompressed) {
    }

    public static enum AccountAddressType {
        AccountId,
        Hex,
        Base64;

    }
}

