/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import java.util.Map;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.FunctionHandle;
import tech.deplant.java4ever.framework.contract.GiverContract;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.TvmCell;

public class EverWalletContract
extends GiverContract {
    public static ContractAbi DEFAULT_ABI() throws JsonProcessingException {
        return ContractAbi.ofString("{\n  \"ABI version\": 2,\n  \"version\": \"2.3\",\n  \"header\": [\n    \"pubkey\",\n    \"time\",\n    \"expire\"\n  ],\n  \"functions\": [\n    {\n      \"name\": \"sendTransaction\",\n      \"inputs\": [\n        {\n          \"name\": \"dest\",\n          \"type\": \"address\"\n        },\n        {\n          \"name\": \"value\",\n          \"type\": \"uint128\"\n        },\n        {\n          \"name\": \"bounce\",\n          \"type\": \"bool\"\n        },\n        {\n          \"name\": \"flags\",\n          \"type\": \"uint8\"\n        },\n        {\n          \"name\": \"payload\",\n          \"type\": \"cell\"\n        }\n      ],\n      \"outputs\": []\n    },\n    {\n      \"name\": \"sendTransactionRaw\",\n      \"inputs\": [\n        {\n          \"name\": \"flags\",\n          \"type\": \"uint8\"\n        },\n        {\n          \"name\": \"message\",\n          \"type\": \"cell\"\n        }\n      ],\n      \"outputs\": []\n    }\n  ],\n  \"data\": [],\n  \"events\": [],\n  \"fields\": [\n    {\n      \"name\": \"_pubkey\",\n      \"type\": \"uint256\"\n    },\n    {\n      \"name\": \"_timestamp\",\n      \"type\": \"uint64\"\n    }\n  ]\n}");
    }

    public EverWalletContract(int sdk, Address address, Credentials credentials) throws JsonProcessingException {
        super(sdk, String.valueOf(address), EverWalletContract.DEFAULT_ABI(), credentials);
    }

    public EverWalletContract(int sdk, Address address, Abi.Signer signer) throws JsonProcessingException {
        super(sdk, String.valueOf(address), EverWalletContract.DEFAULT_ABI(), signer);
    }

    @Override
    public FunctionHandle<Void> sendTransaction(Address dest, BigInteger value, Boolean bounce) {
        Map<String, Object> inputMap = Map.of("dest", dest, "value", value, "bounce", bounce, "flags", 3, "payload", TvmCell.EMPTY.cellBoc());
        return new FunctionHandle<Void>(Void.class, this, "sendTransaction", inputMap, null);
    }
}

