/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.LogUtils;
import tech.deplant.java4ever.framework.Tvc;
import tech.deplant.java4ever.framework.artifact.Artifact;
import tech.deplant.java4ever.framework.artifact.JsonFile;
import tech.deplant.java4ever.framework.artifact.JsonResource;
import tech.deplant.java4ever.framework.artifact.Solc;
import tech.deplant.java4ever.framework.artifact.TvmLinker;
import tech.deplant.java4ever.framework.template.AbstractTemplate;
import tech.deplant.java4ever.framework.template.Template;

public record LocalConfig(Artifact<String, String> artifact, LocalInfo info) {
    private static System.Logger logger = System.getLogger(LocalConfig.class.getName());

    public static LocalConfig EMPTY(String serializationPath, String solcPath, String linkerPath, String stdLibPath, String sourcePath, String buildPath) throws IOException {
        Path path = Paths.get(serializationPath, new String[0]);
        Record jsonArtifact = null;
        switch (Artifact.pathType(serializationPath)) {
            case ABSOLUTE: 
            case RELATIONAL: {
                jsonArtifact = new JsonFile(serializationPath);
                break;
            }
            case RESOURCE: {
                jsonArtifact = new JsonResource(serializationPath);
            }
        }
        LocalConfig config = new LocalConfig((Artifact<String, String>)((Object)jsonArtifact), new LocalInfo(new Solc(solcPath), new TvmLinker(linkerPath, stdLibPath), sourcePath, buildPath, new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, String>(), new ConcurrentHashMap<String, String>()));
        config.sync();
        return config;
    }

    public static LocalConfig LOAD(String serializationPath) throws JsonProcessingException {
        ObjectMapper mapper = JsonContext.ABI_JSON_MAPPER();
        Record jsonArtifact = null;
        switch (Artifact.pathType(serializationPath)) {
            case ABSOLUTE: 
            case RELATIONAL: {
                jsonArtifact = new JsonFile(serializationPath);
                break;
            }
            case RESOURCE: {
                jsonArtifact = new JsonResource(serializationPath);
            }
        }
        return new LocalConfig((Artifact<String, String>)((Object)jsonArtifact), (LocalInfo)mapper.readValue(new JsonFile(serializationPath).get(), LocalInfo.class));
    }

    public Template compileTemplate(String filename, String contractName) throws JsonProcessingException, EverSdkException {
        return this.compileTemplate(this.info().sourcePath(), this.info().buildPath(), filename, contractName, this.info().sourcePath());
    }

    public Template compileTemplate(String sourcePath, String buildPath, String filename, String contractName, String libsPath) throws JsonProcessingException, EverSdkException {
        int compilerResult = this.info().compiler().compileContract(contractName, filename, sourcePath, buildPath, libsPath);
        if (compilerResult == 0) {
            return new AbstractTemplate(ContractAbi.ofFile(buildPath + "/" + contractName + ".abi.json"), Tvc.ofFile(buildPath + "/" + contractName + ".tvc"));
        }
        LogUtils.error(logger, () -> "Sold exit code:" + compilerResult);
        throw new EverSdkException(new EverSdkException.ErrorResult(-600L, "Compilation failed. Sold exit code:" + compilerResult), (Throwable)new Exception());
    }

    public ContractAbi abi(String name) throws JsonProcessingException {
        return ContractAbi.ofFile(this.info().abis().get(name));
    }

    public Credentials credentials(String name) throws JsonProcessingException {
        return Credentials.ofFile(this.info().keys().get(name));
    }

    public Tvc tvc(String name) {
        return Tvc.ofFile(this.info().tvcs().get(name));
    }

    public void addAbiPath(String name, String pathStr) throws IOException {
        this.info().abis().put(name, pathStr);
        this.sync();
    }

    public void addTvcPath(String name, String pathStr) throws IOException {
        this.info().tvcs().put(name, pathStr);
        this.sync();
    }

    public void addKeypairPath(String name, String pathStr) throws IOException {
        this.info().keys().put(name, pathStr);
        this.sync();
    }

    public void sync() throws IOException {
        ObjectMapper mapper = JsonContext.ABI_JSON_MAPPER();
        this.artifact().accept(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.info()));
    }

    public record LocalInfo(Solc compiler, TvmLinker linker, @JsonProperty(value="source_path") String sourcePath, @JsonProperty(value="build_path") String buildPath, Map<String, String> abis, Map<String, String> tvcs, Map<String, String> keys) {
    }
}

