/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.TvmCell;

public record Account(String id, int accType, String balance, String boc, String data, String dataHash, String code, String codeHash, String initCodeHash, String lastTransLt) {
    private static System.Logger logger = System.getLogger(Account.class.getName());

    public static Account ofAddress(int sdk, String addressString) throws EverSdkException {
        HashMap<String, GraphQLFilter.In> filter = new HashMap<String, GraphQLFilter.In>();
        filter.put("id", new GraphQLFilter.In(new String[]{addressString}));
        Net.ResultOfQueryCollection result = (Net.ResultOfQueryCollection)EverSdk.await((CompletableFuture)Net.queryCollection((int)sdk, (String)"accounts", (JsonNode)JsonContext.ABI_JSON_MAPPER().valueToTree(filter), (String)"id acc_type balance boc data data_hash code code_hash init_code_hash last_trans_lt", null, null));
        if (result.result().length > 0) {
            try {
                return (Account)JsonContext.SDK_JSON_MAPPER().readValue(result.result()[0].traverse(), Account.class);
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.ERROR, e);
                return Account.ofUninit(addressString);
            }
        }
        return Account.ofUninit(addressString);
    }

    public static Account ofAddress(int sdk, Address address) throws EverSdkException {
        return Account.ofAddress(sdk, address.makeAddrStd());
    }

    public static Account ofUninit(Address address) {
        return Account.ofUninit(address.makeAddrStd());
    }

    public static Account ofUninit(String addressString) {
        return new Account(addressString, 0, "0x00", TvmCell.EMPTY.cellBoc(), TvmCell.EMPTY.cellBoc(), "0x00", TvmCell.EMPTY.cellBoc(), "0x00", "0x00", "0x00");
    }

    public static List<Account> ofAddressList(int sdk, String ... addresses) throws EverSdkException {
        HashMap<String, GraphQLFilter.In> filter = new HashMap<String, GraphQLFilter.In>();
        filter.put("id", new GraphQLFilter.In(addresses));
        return Arrays.stream(((Net.ResultOfQueryCollection)EverSdk.await((CompletableFuture)Net.queryCollection((int)sdk, (String)"accounts", (JsonNode)JsonContext.ABI_JSON_MAPPER().valueToTree(filter), (String)"id acc_type balance boc data data_hash code code_hash init_code_hash last_trans_lt", null, null))).result()).map(obj -> (Account)JsonContext.SDK_JSON_MAPPER().convertValue(obj, Account.class)).toList();
    }

    public Boolean isActive() {
        return 1 == this.accType;
    }

    public static interface GraphQLFilter {

        public record Lt(String lt) implements GraphQLFilter
        {
        }

        public record Gt(String gt) implements GraphQLFilter
        {
        }

        public record Eq(Integer eq) implements GraphQLFilter
        {
        }

        public record In(String[] in) implements GraphQLFilter
        {
        }
    }
}

