/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.artifact;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import tech.deplant.java4ever.framework.artifact.Artifact;
import tech.deplant.java4ever.utils.Fls;

public record JsonFile(Path filePath) implements Artifact<String, String>
{
    public JsonFile(String filePathString) {
        this(Paths.get(filePathString, new String[0]));
    }

    @Override
    public String get() {
        try {
            return Files.readString(this.filePath(), StandardCharsets.UTF_8).replaceAll("[\u0000-\u001f]", "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void accept(String jsonString) {
        try {
            Fls.write((Path)this.filePath(), (String)jsonString);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

