/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Set;
import javax.lang.model.element.Modifier;
import tech.deplant.javapoet.AnnotationSpec;
import tech.deplant.javapoet.ParameterSpec;
import tech.deplant.javapoet.TypeName;

public class ParserUtils {
    public static final Set<String> JAVA_RESERVED_WORDS = Set.of("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronize", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while");

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    public static String capitalize(String str) {
        int codePoint;
        int newCodePoint;
        int strLen = ParserUtils.length(str);
        if (strLen == 0) {
            return str;
        }
        int firstCodepoint = str.codePointAt(0);
        if (firstCodepoint == (newCodePoint = Character.toTitleCase(firstCodepoint))) {
            return str;
        }
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        newCodePoints[outOffset++] = newCodePoint;
        for (int inOffset = Character.charCount(firstCodepoint); inOffset < strLen; inOffset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(inOffset);
            newCodePoints[outOffset++] = codePoint;
        }
        return new String(newCodePoints, 0, outOffset);
    }

    public static String camelCase(String str) {
        String[] wordArray = str.split("_");
        StringBuilder builder = new StringBuilder();
        builder.append(wordArray[0].toLowerCase());
        Arrays.stream(wordArray).skip(1L).forEach(w -> {
            builder.append(w.substring(0, 1).toUpperCase());
            builder.append(w.substring(1).toLowerCase());
        });
        return builder.toString();
    }

    public static String toCapitalCase(String str) {
        return ParserUtils.capitalize(ParserUtils.camelCase(str));
    }

    public static AnnotationSpec renamedFieldAnnotation(String originalName) {
        return AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{originalName}).build();
    }

    public static ParameterSpec.Builder processReservedNames(TypeName paramType, String paramName) {
        ParameterSpec.Builder paramBuilder;
        if (JAVA_RESERVED_WORDS.contains(paramName)) {
            paramBuilder = ParameterSpec.builder((TypeName)paramType, (String)("_" + paramName), (Modifier[])new Modifier[0]);
            paramBuilder.addAnnotation(ParserUtils.renamedFieldAnnotation(paramName));
        } else if (paramName.contains(" ")) {
            paramBuilder = ParameterSpec.builder((TypeName)paramType, (String)paramName.trim().replace(" ", "__"), (Modifier[])new Modifier[0]);
            paramBuilder.addAnnotation(ParserUtils.renamedFieldAnnotation(paramName));
        } else {
            paramBuilder = ParameterSpec.builder((TypeName)paramType, (String)paramName, (Modifier[])new Modifier[0]);
        }
        return paramBuilder;
    }
}

