/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.ffi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.AppObject;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.ffi.NativeMethods;
import tech.deplant.java4ever.binding.ffi.NativeStrings;
import tech.deplant.java4ever.binding.ffi.tc_response_handler_t;
import tech.deplant.java4ever.binding.ffi.tc_response_types;

public class EverSdkContext
implements tc_response_handler_t.Function {
    private static final System.Logger logger = System.getLogger(EverSdkContext.class.getName());
    private final int id;
    private final AtomicInteger requestCount = new AtomicInteger();
    private final Client.ClientConfig clientConfig;
    private final long timeout;
    @JsonIgnore
    private final Map<Integer, RequestData> requests = new ConcurrentHashMap<Integer, RequestData>();
    @JsonIgnore
    private final Map<Integer, Consumer<JsonNode>> subscriptions = new ConcurrentHashMap<Integer, Consumer<JsonNode>>();
    @JsonIgnore
    private final Queue<RequestData> cleanupQueue = new ConcurrentLinkedDeque<RequestData>();

    public EverSdkContext(int id, Client.ClientConfig clientConfig) {
        this.id = id;
        this.clientConfig = clientConfig;
        this.timeout = this.extractTimeout(clientConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, P, AP, AR> CompletableFuture<R> callAsync(String functionName, P functionInputs, Class<R> resultClass, Consumer<JsonNode> eventConsumer, AppObject<AP, AR> appObject) throws EverSdkException {
        int requestId = this.requestCountNextVal();
        this.cleanup();
        boolean hasResponse = !resultClass.equals(Void.class);
        RequestData<R> request = new RequestData<R>(hasResponse, Arena.ofAuto(), new ReentrantLock(), resultClass, new CompletableFuture(), eventConsumer, appObject);
        this.requests.put(requestId, request);
        String paramsJson = this.processParams(functionInputs);
        request.queueLock().lock();
        try {
            NativeMethods.tcRequest(this.id, functionName, paramsJson, request.nativeArena(), requestId, this);
        }
        finally {
            request.queueLock().unlock();
            logger.log(System.Logger.Level.TRACE, () -> "CTX:%d REQ:%d FUNC:%s %s:%s".formatted(this.id, requestId, functionName, "SEND", paramsJson));
        }
        if (!hasResponse) {
            request.responseFuture().complete(null);
        }
        return request.responseFuture();
    }

    public int requestCountNextVal() {
        return this.requestCount.incrementAndGet();
    }

    public void addResponse(int requestId, RequestData request, String responseString) {
        if (request.hasResponse()) {
            try {
                if (!request.responseFuture().isDone()) {
                    logger.log(System.Logger.Level.TRACE, () -> "CTX:%d REQ:%d RESP:%s".formatted(this.id, requestId, responseString));
                    request.responseFuture().complete(JsonContext.SDK_JSON_MAPPER().readValue(responseString, request.responseClass()));
                } else {
                    logger.log(System.Logger.Level.ERROR, "Slot for this request not found on processing response! CTX:%d REQ:%d RESP:%s".formatted(this.id, requestId, responseString));
                }
            }
            catch (JsonProcessingException ex2) {
                logger.log(System.Logger.Level.ERROR, () -> "CTX:%d REQ:%d EVER-SDK Response deserialization failed! %s".formatted(this.id, requestId, ex2.toString()));
                request.responseFuture().completeExceptionally(new EverSdkException(new EverSdkException.ErrorResult(-500L, "EVER-SDK response deserialization failed!"), ex2.getCause()));
            }
        }
    }

    private void addError(int requestId, RequestData request, String responseString) {
        CompletableFuture completableFuture = request.responseFuture();
        if (completableFuture instanceof CompletableFuture) {
            CompletableFuture future = completableFuture;
            try {
                logger.log(System.Logger.Level.WARNING, () -> "CTX:%d REQ:%d ERR:%s".formatted(this.id, requestId, responseString));
                EverSdkException.ErrorResult sdkResponse = (EverSdkException.ErrorResult)JsonContext.SDK_JSON_MAPPER().readValue(responseString, EverSdkException.ErrorResult.class);
                future.completeExceptionally(new EverSdkException(sdkResponse));
            }
            catch (JsonProcessingException ex1) {
                logger.log(System.Logger.Level.ERROR, () -> "CTX:%d REQ:%d EVER-SDK Error deserialization failed! %s".formatted(this.id, requestId, ex1.toString()));
                future.completeExceptionally(new EverSdkException(new EverSdkException.ErrorResult(-500L, "EVER-SDK Error deserialization failed!"), ex1.getCause()));
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Slot for this request not found on processing error response! CTX:%d REQ:%d ERR:%s".formatted(this.id, requestId, responseString));
        }
    }

    private void addEvent(int requestId, RequestData request, String responseString, int responseType) {
        Consumer<JsonNode> consumer = request.subscriptionHandler();
        if (consumer instanceof Consumer) {
            Consumer<JsonNode> handler = consumer;
            try {
                JsonNode node = JsonContext.ABI_JSON_MAPPER().readTree(responseString);
                try {
                    handler.accept(node);
                }
                catch (Exception ex1) {
                    logger.log(System.Logger.Level.ERROR, () -> "REQ:%d EVENT:%s Subscribe Event Action processing failed! %s".formatted(requestId, responseString, ex1.toString()));
                }
            }
            catch (JsonProcessingException ex2) {
                logger.log(System.Logger.Level.ERROR, () -> "REQ:%d EVENT:%s Subscribe Event JSON deserialization failed! %s".formatted(requestId, responseString, ex2.toString()));
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Slot for this request not found on processing subscription event! CTX:%d REQ:%d EVENT:%s".formatted(this.id, requestId, responseString));
        }
    }

    private void finishRequest(int requestId, RequestData request) {
        this.cleanupQueue.add(request);
        this.requests.remove(requestId);
        this.subscriptions.remove(requestId);
    }

    private void cleanup() {
        RequestData requestData;
        while ((requestData = this.cleanupQueue.poll()) instanceof RequestData) {
            RequestData request = requestData;
            request.queueLock().lock();
            logger.log(System.Logger.Level.TRACE, () -> "Memory session arena closed");
            request.queueLock().unlock();
        }
    }

    private <P> String processParams(P params) {
        try {
            return null == params ? "" : JsonContext.SDK_JSON_MAPPER().writeValueAsString(params);
        }
        catch (JsonProcessingException e) {
            logger.log(System.Logger.Level.ERROR, () -> "Parameters serialization failed!" + e.getMessage() + String.valueOf(e.getCause()));
            throw new IllegalArgumentException("Parameters serialization failed!", e);
        }
    }

    private long extractTimeout(Client.ClientConfig cfg) {
        Client.ClientConfig clientConfig = cfg;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Client.ClientConfig.class}, (Object)clientConfig, n)) {
            case -1 -> 60000L;
            default -> {
                Client.ClientConfig cl = clientConfig;
                Client.NetworkConfig var6_5 = cl.network();
                int var7_6 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Client.NetworkConfig.class}, (Object)var6_5, var7_6)) {
                    case -1: {
                        yield 60000L;
                    }
                }
                Client.NetworkConfig ntwrk = var6_5;
                yield Objects.requireNonNullElse(ntwrk.queryTimeout(), 60000L);
            }
        };
    }

    private <R> R awaitSyncResponse(CompletableFuture<R> requestId, Class<R> resultClass) throws EverSdkException {
        try {
            String responseString = (String)this.requests.get(requestId).responseFuture().get(this.timeout, TimeUnit.MILLISECONDS);
            logger.log(System.Logger.Level.TRACE, () -> "CTX:%d REQ:%d RESP:%s".formatted(this.id, requestId, responseString));
            return (R)JsonContext.SDK_JSON_MAPPER().readValue(responseString, resultClass);
        }
        catch (InterruptedException ex3) {
            logger.log(System.Logger.Level.ERROR, () -> "CTX:%d REQ:%d EVER-SDK Call interrupted! %s}".formatted(this.id, requestId, ex3.toString()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-400L, "EVER-SDK call interrupted!"), ex3.getCause());
        }
        catch (TimeoutException ex4) {
            logger.log(System.Logger.Level.ERROR, () -> "CTX:%d REQ:%d EVER-SDK Call expired on Timeout! %s".formatted(this.id, requestId, ex4.toString()));
            throw new EverSdkException(new EverSdkException.ErrorResult(-408L, "EVER-SDK call expired on Timeout!"), ex4.getCause());
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public int id() {
        return this.id;
    }

    public int requestCount() {
        return this.requestCount.get();
    }

    public Client.ClientConfig config() {
        return this.clientConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void apply(int request_id, MemorySegment params_json, int response_type, boolean finished) {
        RequestData requestData = this.requests.get(request_id);
        if (requestData instanceof RequestData) {
            RequestData request = requestData;
            request.queueLock().lock();
            try {
                String responseString = NativeStrings.toJava(params_json);
                if (logger.isLoggable(System.Logger.Level.TRACE)) {
                    logger.log(System.Logger.Level.TRACE, "REQ:%d TYPE:%d FINISHED:%s JSON:%s".formatted(this.id, response_type, String.valueOf(finished), responseString));
                }
                switch (tc_response_types.of(response_type)) {
                    case TC_RESPONSE_SUCCESS: {
                        this.addResponse(request_id, request, responseString);
                        break;
                    }
                    case TC_RESPONSE_ERROR: {
                        this.addError(request_id, request, responseString);
                        break;
                    }
                    case TC_RESPONSE_CUSTOM: {
                        this.addEvent(request_id, request, responseString, response_type);
                    }
                }
                if (!finished) return;
                this.finishRequest(request_id, request);
                return;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "REQ:%d TYPE:%d EVER-SDK Unexpected upcall error! %s".formatted(request_id, response_type, e.toString()));
                return;
            }
            finally {
                request.queueLock().unlock();
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "REQ:%d TYPE:%d EVER-SDK Response on cleaned request!".formatted(request_id, response_type));
        }
    }

    private record RequestData<R>(boolean hasResponse, Arena nativeArena, ReentrantLock queueLock, Class<R> responseClass, CompletableFuture<R> responseFuture, Consumer<JsonNode> subscriptionHandler, AppObject appObject) {
    }

    record SubscriptionHandler(Consumer<JsonNode> eventAction) {
    }
}

