/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator.jtype;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import tech.deplant.commons.Objs;
import tech.deplant.commons.Strings;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Unstable;
import tech.deplant.java4ever.binding.generator.ParserEngine;
import tech.deplant.java4ever.binding.generator.ParserUtils;
import tech.deplant.java4ever.binding.generator.TypeReference;
import tech.deplant.java4ever.binding.generator.jtype.SdkDocs;
import tech.deplant.java4ever.binding.generator.jtype.SdkObject;
import tech.deplant.java4ever.binding.generator.jtype.SdkParam;
import tech.deplant.java4ever.binding.generator.reference.ApiFunction;
import tech.deplant.java4ever.binding.generator.reference.ApiType;
import tech.deplant.java4ever.binding.generator.reference.GenericType;
import tech.deplant.java4ever.binding.generator.reference.RefType;
import tech.deplant.java4ever.binding.generator.reference.StructType;
import tech.deplant.javapoet.AnnotationSpec;
import tech.deplant.javapoet.ClassName;
import tech.deplant.javapoet.CodeBlock;
import tech.deplant.javapoet.MethodSpec;
import tech.deplant.javapoet.ParameterSpec;
import tech.deplant.javapoet.ParameterizedTypeName;
import tech.deplant.javapoet.TypeName;

public record SdkFunction(String functionModule, ApiFunction function, Map<ParserEngine.SdkType, SdkObject> typeLibrary) {
    private static final System.Logger logger = System.getLogger(SdkFunction.class.getName());

    private String constructCallParams(MethodSpec.Builder methodBuilder, List<Object> statementArgs, SdkParam param) {
        StringBuilder template = new StringBuilder();
        if (Objs.isNotNull((Object)param.libType()) && param.libType().isStructure() && Strings.safeSubstrEquals((String)param.libType().name(), (int)0, (int)8, (boolean)false, (String)"ParamsOf")) {
            StructType structType = (StructType)param.libType().type();
            template.append("new $T(");
            statementArgs.add(param.refClassName());
            String innerFields = Arrays.stream(structType.struct_fields()).map(apiType -> this.constructCallParams(methodBuilder, statementArgs, SdkParam.ofApiType(apiType, this.typeLibrary()))).collect(Collectors.joining(", "));
            template.append(innerFields);
            template.append(")");
        } else {
            template.append("$N");
            ParameterSpec spec = param.poeticize().build();
            methodBuilder.addParameter(spec);
            statementArgs.add(spec);
        }
        return template.toString();
    }

    public MethodSpec.Builder poeticize() {
        TypeReference resultReference;
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)ParserUtils.camelCase(this.function().name())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addException((TypeName)ClassName.get(EverSdkException.class));
        ArrayList<Object> statementArgs = new ArrayList<Object>();
        statementArgs.add(String.format("%s.%s", this.functionModule().toLowerCase(), this.function().name()));
        String templateString = "%RETURN_KEY%EverSdk.%CALL_TYPE%(ctxId, $S, %PARAMS%%RETURN_CLASS%%APP_OBJ%)";
        methodBuilder.addParameter(ClassName.INT, "ctxId", new Modifier[0]);
        block14: for (ApiType param : this.function().params()) {
            logger.log(System.Logger.Level.TRACE, () -> this.function().name() + "\\" + param.name() + "\\" + param.type());
            switch (param.name()) {
                case "context": 
                case "_context": {
                    continue block14;
                }
                case "params": {
                    SdkParam parsedParam = SdkParam.ofApiType(param, this.typeLibrary());
                    templateString = templateString.replace("%PARAMS%", this.constructCallParams(methodBuilder, statementArgs, parsedParam));
                    continue block14;
                }
                case "callback": {
                    templateString = templateString.replace("%APP_OBJ%", ", callback");
                    templateString = templateString.replace("%CALL_TYPE%", "asyncCallback");
                    ClassName paramClass = ClassName.get(JsonNode.class);
                    methodBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{paramClass}), "callback", new Modifier[0]);
                    continue block14;
                }
                case "app_object": 
                case "password_provider": {
                    templateString = templateString.replace("%APP_OBJ%", ", appObject");
                    templateString = templateString.replace("%CALL_TYPE%", "asyncAppObject");
                    if (!(param instanceof GenericType)) continue block14;
                    GenericType gen = (GenericType)param;
                    TypeName[] appObjectParams = (TypeName[])Arrays.stream(gen.generic_args()).map(arg -> {
                        ApiType selector0$temp = arg;
                        int index$1 = 0;
                        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RefType.class}, (Object)selector0$temp, index$1)) {
                            case -1 -> null;
                            case 0 -> {
                                RefType ref = (RefType)selector0$temp;
                                yield SdkParam.ofApiType(ref, this.typeLibrary());
                            }
                            default -> null;
                        };
                    }).filter(Objects::nonNull).map(SdkParam::refClassName).toArray(TypeName[]::new);
                    methodBuilder.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.bestGuess((String)gen.generic_name()), (TypeName[])appObjectParams), "appObject", new Modifier[0]);
                    continue block14;
                }
                default: {
                    logger.log(System.Logger.Level.WARNING, () -> "Unknown parameter: " + param.name());
                }
            }
        }
        templateString = templateString.replace("%APP_OBJ%", "");
        templateString = templateString.replace("%PARAMS%", "null");
        if (Objs.isNotNull((Object)this.function().result()) && !(resultReference = TypeReference.fromApiType(this.function().result())).isVoid()) {
            templateString = templateString.replace("%RETURN_KEY%", "return ");
            templateString = templateString.replace("%CALL_TYPE%", "async");
            templateString = templateString.replace("%RETURN_CLASS%", ", $T.class");
            TypeName typeName = resultReference.toTypeName();
            methodBuilder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{typeName}));
            statementArgs.add(typeName);
        }
        templateString = templateString.replace("%RETURN_KEY%", "");
        templateString = templateString.replace("%CALL_TYPE%", "asyncVoid");
        String finalTemplateString = templateString = templateString.replace("%RETURN_CLASS%", "");
        logger.log(System.Logger.Level.TRACE, () -> "Template: " + finalTemplateString);
        statementArgs.forEach(arg -> logger.log(System.Logger.Level.TRACE, () -> "Arg[]: " + arg.toString()));
        methodBuilder.addCode(CodeBlock.builder().addStatement(templateString, statementArgs.toArray()).build());
        if (Objs.isNotNull((Object)this.function().summary()) && this.function().summary().toUpperCase().contains("UNSTABLE") || Objs.isNotNull((Object)this.function().description()) && this.function().description().toUpperCase().contains("UNSTABLE")) {
            methodBuilder.addAnnotation(AnnotationSpec.builder(Unstable.class).build());
        }
        if (Objs.isNotNull((Object)this.function().summary()) && this.function().summary().toUpperCase().contains("DEPRECATED") || Objs.isNotNull((Object)this.function().description()) && this.function().description().toUpperCase().contains("DEPRECATED")) {
            methodBuilder.addAnnotation(AnnotationSpec.builder(Deprecated.class).build());
        }
        methodBuilder.addJavadoc(new SdkDocs(this.function().summary(), this.function().description()).poeticize().build());
        return methodBuilder;
    }
}

