/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.gql;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import tech.deplant.java4ever.binding.JsonContext;

public record HttpRequestHandle(HttpClient client, HttpRequest request) {
    private static final System.Logger logger = System.getLogger(HttpRequestHandle.class.getName());

    public static HttpRequestHandle ofGraphQL(String urlString, String body) throws JsonProcessingException {
        return HttpRequestHandle.ofGraphQL(urlString, body, HttpClient.Version.HTTP_1_1);
    }

    public static HttpRequestHandle ofGraphQL(String urlString, String gqlQuery, HttpClient.Version version) throws JsonProcessingException {
        String body = "{\"query\": " + JsonContext.ABI_JSON_MAPPER().writeValueAsString((Object)("{" + gqlQuery + "}")) + " }";
        logger.log(System.Logger.Level.DEBUG, body);
        return new HttpRequestHandle(HttpClient.newHttpClient(), HttpRequest.newBuilder().uri(URI.create(urlString)).POST(HttpRequest.BodyPublishers.ofString(body)).version(version).header("Content-Type", "application/json").header("Accept", "application/json").header("Accept-Encoding", "gzip, deflate").build());
    }

    public HttpResponse<String> send() throws IOException, InterruptedException {
        return this.client().send(this.request(), HttpResponse.BodyHandlers.ofString());
    }
}

