/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator.jtype;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.lang.model.element.Modifier;
import tech.deplant.java4ever.binding.generator.ParserEngine;
import tech.deplant.java4ever.binding.generator.ParserUtils;
import tech.deplant.java4ever.binding.generator.TypeReference;
import tech.deplant.java4ever.binding.generator.javapoet.AnnotationSpec;
import tech.deplant.java4ever.binding.generator.javapoet.ParameterSpec;
import tech.deplant.java4ever.binding.generator.javapoet.TypeName;
import tech.deplant.java4ever.binding.generator.jtype.SdkDocs;
import tech.deplant.java4ever.binding.generator.jtype.SdkDummy;
import tech.deplant.java4ever.binding.generator.jtype.SdkObject;
import tech.deplant.java4ever.binding.generator.reference.ApiType;

public record SdkParam(TypeName refClassName, String parameterName, String origParamName, boolean hasReserved, String summary, String description, SdkObject libType) {
    public static final Map<String, String> RESERVED_FIELD_NAMES = Map.of("public", "public_key", "secret", "secret_key", "switch", "switch_to", "ABI version", "abi_version_major");

    public static SdkParam ofApiType(ApiType paramType, Map<ParserEngine.SdkType, SdkObject> typeLibrary) {
        TypeName className;
        TypeReference typeReference = TypeReference.fromApiType(paramType);
        SdkObject javaType = typeReference.toTypeDeclaration(typeLibrary);
        if (javaType instanceof SdkDummy) {
            SdkDummy dummy = (SdkDummy)javaType;
            className = TypeReference.fromApiType(dummy.type()).toTypeName();
        } else {
            className = typeReference.toTypeName();
        }
        String paramName = "Context".equals(className.toString()) ? "ctx" : paramType.name();
        String reservedName = RESERVED_FIELD_NAMES.getOrDefault(paramName, paramName);
        boolean hasReserved = false;
        if (!reservedName.equals(paramName)) {
            hasReserved = true;
        }
        return new SdkParam(className, ParserUtils.camelCase(reservedName), paramName, hasReserved, paramType.summary(), paramType.description(), typeReference.toTypeDeclaration(typeLibrary));
    }

    public static AnnotationSpec renamedFieldAnnotation(String originalName) {
        return AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", originalName).build();
    }

    public ParameterSpec.Builder poeticize() {
        ParameterSpec.Builder componentBuilder = ParameterSpec.builder(this.refClassName(), this.parameterName(), new Modifier[0]);
        if (this.hasReserved()) {
            componentBuilder.addAnnotation(SdkParam.renamedFieldAnnotation(this.origParamName()));
        }
        componentBuilder.addJavadoc(new SdkDocs(this.summary(), this.description()).poeticize().build());
        return componentBuilder;
    }
}

