/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.generator;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.SubscribeEvent;
import tech.deplant.java4ever.binding.generator.ParserEngine;
import tech.deplant.java4ever.binding.generator.ParserUtils;
import tech.deplant.java4ever.binding.generator.javapoet.ArrayTypeName;
import tech.deplant.java4ever.binding.generator.javapoet.ClassName;
import tech.deplant.java4ever.binding.generator.javapoet.TypeName;
import tech.deplant.java4ever.binding.generator.jtype.SdkObject;
import tech.deplant.java4ever.binding.generator.reference.ApiType;
import tech.deplant.java4ever.binding.generator.reference.ArrayType;
import tech.deplant.java4ever.binding.generator.reference.BigIntType;
import tech.deplant.java4ever.binding.generator.reference.BooleanType;
import tech.deplant.java4ever.binding.generator.reference.GenericType;
import tech.deplant.java4ever.binding.generator.reference.NoneType;
import tech.deplant.java4ever.binding.generator.reference.NumberType;
import tech.deplant.java4ever.binding.generator.reference.OptionalType;
import tech.deplant.java4ever.binding.generator.reference.RefType;
import tech.deplant.java4ever.binding.generator.reference.StringType;
import tech.deplant.java4ever.utils.Strings;

public record TypeReference(String module, String name, boolean isArray, boolean isOptional, boolean isGeneric, boolean isRef, boolean isVoid) {
    private static final List<String> SPECIAL_REFS = List.of("Value", "API", "ClientContext");
    private static final System.Logger logger = System.getLogger(TypeReference.class.getName());

    public static TypeReference fromApiType(ApiType apiType) {
        return TypeReference.referenceRecursion(new TypeReference(null, null, false, false, false, false, false), apiType);
    }

    private static TypeReference referenceRecursion(TypeReference ref, ApiType apiType) {
        ApiType apiType2 = apiType;
        Objects.requireNonNull(apiType2);
        ApiType apiType3 = apiType2;
        int n = 0;
        TypeReference typeReference = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GenericType.class, OptionalType.class, ArrayType.class, RefType.class, NumberType.class, StringType.class, BooleanType.class, BigIntType.class, NoneType.class}, (Object)apiType3, n)) {
            case 0 -> {
                GenericType gen = (GenericType)apiType3;
                if ("AppObject".equals(gen.generic_name())) {
                    logger.log(System.Logger.Level.WARNING, () -> "AppObject! : " + String.valueOf(ref) + " generic: " + String.valueOf(gen));
                }
                yield TypeReference.referenceRecursion(ref.withIsGeneric(true), gen.generic_args()[0]);
            }
            case 1 -> {
                OptionalType opt = (OptionalType)apiType3;
                yield TypeReference.referenceRecursion(ref.withIsOptional(true), opt.optional_inner());
            }
            case 2 -> {
                ArrayType arr = (ArrayType)apiType3;
                yield TypeReference.referenceRecursion(ref.withIsArray(true), arr.array_item());
            }
            case 3 -> {
                RefType r = (RefType)apiType3;
                if (SPECIAL_REFS.contains(r.ref_name())) {
                    if (Strings.isNotEmpty((String)apiType.summary()) && apiType.summary().contains("integer number")) {
                        yield ref.withName("String").withIsRef(false);
                    }
                    yield ref.withName(r.ref_name()).withIsRef(false);
                }
                yield ref.withName(r.ref_name()).withIsRef(true);
            }
            case 4 -> {
                NumberType num = (NumberType)apiType3;
                if (num.number_size() >= 32) {
                    yield ref.withName("Long").withIsRef(false);
                }
                yield ref.withName("Integer").withIsRef(false);
            }
            case 5 -> {
                StringType str = (StringType)apiType3;
                yield ref.withName("String").withIsRef(false);
            }
            case 6 -> {
                BooleanType bool = (BooleanType)apiType3;
                yield ref.withName("Boolean").withIsRef(false);
            }
            case 7 -> {
                BigIntType bigInt = (BigIntType)apiType3;
                yield ref.withName("BigInteger").withIsRef(false);
            }
            case 8 -> {
                NoneType none = (NoneType)apiType3;
                yield ref.withIsVoid(true);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(apiType));
        };
        if (typeReference != null && typeReference.module() == null && typeReference.isRef() && typeReference.name().length() > 0) {
            String[] splittedName = typeReference.name().split("\\.");
            if (splittedName.length < 2) {
                logger.log(System.Logger.Level.ERROR, () -> "Type reference without 'module.type' notation! " + String.valueOf(typeReference));
                return typeReference;
            }
            String refName = "Abi".equals(splittedName[1]) ? "ABI" : splittedName[1];
            return typeReference.withModule(ParserUtils.capitalize(splittedName[0])).withName(refName);
        }
        return typeReference;
    }

    public TypeReference withModule(String module) {
        return new TypeReference(module, this.name(), this.isArray(), this.isOptional(), this.isGeneric(), this.isRef(), this.isVoid());
    }

    public TypeReference withName(String name) {
        return new TypeReference(this.module(), name, this.isArray(), this.isOptional(), this.isGeneric(), this.isRef(), this.isVoid());
    }

    public TypeReference withIsArray(boolean isArray) {
        return new TypeReference(this.module(), this.name(), isArray, this.isOptional(), this.isGeneric(), this.isRef(), this.isVoid());
    }

    public TypeReference withIsOptional(boolean isOptional) {
        return new TypeReference(this.module(), this.name(), this.isArray(), isOptional, this.isGeneric(), this.isRef(), this.isVoid());
    }

    public TypeReference withIsGeneric(boolean isGeneric) {
        return new TypeReference(this.module(), this.name(), this.isArray(), this.isOptional(), isGeneric, this.isRef(), this.isVoid());
    }

    public TypeReference withIsRef(boolean isRef) {
        return new TypeReference(this.module(), this.name(), this.isArray(), this.isOptional(), this.isGeneric(), isRef, this.isVoid());
    }

    public TypeReference withIsVoid(boolean isVoid) {
        return new TypeReference(this.module(), this.name(), this.isArray(), this.isOptional(), this.isGeneric(), this.isRef(), isVoid);
    }

    public TypeName toTypeName() {
        TypeName typeName;
        if (this.isRef()) {
            typeName = switch (this.name()) {
                case "Request" -> {
                    logger.log(System.Logger.Level.WARNING, () -> "Callback!");
                    yield ClassName.get(SubscribeEvent.class);
                }
                default -> ClassName.bestGuess(this.module() + "." + this.name());
            };
        } else {
            typeName = switch (this.name()) {
                case "Integer" -> ClassName.get(Integer.class);
                case "String" -> TypeName.STRING;
                case "Boolean" -> ClassName.get(Boolean.class);
                case "Long" -> ClassName.get(Long.class);
                case "BigInteger" -> ClassName.get(BigInteger.class);
                case "Value", "API" -> ClassName.get(JsonNode.class);
                case "ClientContext" -> ClassName.get(EverSdkContext.class);
                default -> throw new IllegalStateException("Unexpected value: " + this.name());
            };
        }
        if (this.isArray()) {
            typeName = ArrayTypeName.of(typeName);
        }
        return typeName;
    }

    public SdkObject toTypeDeclaration(Map<ParserEngine.SdkType, SdkObject> typeLibrary) {
        return typeLibrary.get(this.toSdkType());
    }

    public ParserEngine.SdkType toSdkType() {
        return new ParserEngine.SdkType(this.module(), this.name());
    }
}

