/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.ffi;

import java.lang.foreign.MemorySegment;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import tech.deplant.java4ever.binding.CallbackHandler;
import tech.deplant.java4ever.binding.ffi.SdkBridge;
import tech.deplant.java4ever.binding.ffi.tc_response_handler_t;
import tech.deplant.java4ever.binding.ffi.ton_client;

public class SdkResponseHandler
implements tc_response_handler_t {
    private static final System.Logger logger = System.getLogger(SdkResponseHandler.class.getName());
    private final CompletableFuture<String> result = new CompletableFuture();
    private final Consumer<CallbackHandler> handlerConsumer;

    public SdkResponseHandler(Consumer<CallbackHandler> consumer) {
        this.handlerConsumer = consumer;
    }

    @Override
    public void apply(int x0, MemorySegment x1, int x2, boolean x3) {
        if (x2 == ton_client.tc_response_success()) {
            this.result.complete(SdkBridge.toString(x1));
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, RESULT".formatted(x0));
        } else if (x2 == ton_client.tc_response_error()) {
            this.result.completeExceptionally(new CompletionException(SdkBridge.toString(x1), null));
            logger.log(System.Logger.Level.WARNING, () -> "REQID: %d, ERROR".formatted(x0));
        } else if (x2 == ton_client.tc_response_nop()) {
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, NOP".formatted(x0));
            if (x3) {
                this.result.complete(null);
            }
        } else if (x2 == ton_client.tc_response_app_request()) {
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, APP_REQUEST".formatted(x0));
        } else if (x2 == ton_client.tc_response_app_notify()) {
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, APP_NOTIFY".formatted(x0));
        } else if (x2 > ton_client.tc_response_app_notify() && x2 < ton_client.tc_response_custom()) {
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, RESERVED".formatted(x0));
            if (x3) {
                this.result.complete(SdkBridge.toString(x1));
            }
        } else {
            logger.log(System.Logger.Level.TRACE, () -> "REQID: %d, CUSTOM #%d, %s".formatted(x0, x2, SdkBridge.toString(x1)));
            if (this.handlerConsumer != null) {
                this.handlerConsumer.accept(new CallbackHandler(SdkBridge.toString(x1), x2));
            }
        }
    }

    public CompletableFuture<String> result() {
        return this.result;
    }
}

