/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Processing;

public final class Tvm {
    public static ResultOfRunExecutor runExecutor(EverSdkContext ctx, String message, AccountForExecutor account, ExecutionOptions executionOptions, Abi.ABI abi, Boolean skipTransactionCheck, Boc.BocCacheType bocCache, Boolean returnUpdatedAccount) throws EverSdkException {
        return ctx.call("tvm.run_executor", new ParamsOfRunExecutor(message, account, executionOptions, abi, skipTransactionCheck, bocCache, returnUpdatedAccount), ResultOfRunExecutor.class);
    }

    public static ResultOfRunTvm runTvm(EverSdkContext ctx, String message, String account, ExecutionOptions executionOptions, Abi.ABI abi, Boc.BocCacheType bocCache, Boolean returnUpdatedAccount) throws EverSdkException {
        return ctx.call("tvm.run_tvm", new ParamsOfRunTvm(message, account, executionOptions, abi, bocCache, returnUpdatedAccount), ResultOfRunTvm.class);
    }

    public static ResultOfRunGet runGet(EverSdkContext ctx, String account, String functionName, Map<String, Object> input, ExecutionOptions executionOptions, Boolean tupleListAsArray) throws EverSdkException {
        return ctx.call("tvm.run_get", new ParamsOfRunGet(account, functionName, input, executionOptions, tupleListAsArray), ResultOfRunGet.class);
    }

    public record ParamsOfRunExecutor(String message, AccountForExecutor account, ExecutionOptions executionOptions, Abi.ABI abi, Boolean skipTransactionCheck, Boc.BocCacheType bocCache, Boolean returnUpdatedAccount) {
    }

    public static sealed interface AccountForExecutor {

        public record Account(String boc, Boolean unlimitedBalance) implements AccountForExecutor
        {
            @JsonProperty(value="type")
            public String type() {
                return "Account";
            }
        }

        public record Uninit() implements AccountForExecutor
        {
            @JsonProperty(value="type")
            public String type() {
                return "Uninit";
            }
        }

        public record None() implements AccountForExecutor
        {
            @JsonProperty(value="type")
            public String type() {
                return "None";
            }
        }
    }

    public record ExecutionOptions(String blockchainConfig, Integer blockTime, Long blockLt, Long transactionLt, Boolean chksigAlwaysSucceed, Integer signatureId) {
    }

    public record ResultOfRunExecutor(Map<String, Object> transaction, String[] outMessages, Processing.DecodedOutput decoded, String account, TransactionFees fees) {
    }

    public record ParamsOfRunTvm(String message, String account, ExecutionOptions executionOptions, Abi.ABI abi, Boc.BocCacheType bocCache, Boolean returnUpdatedAccount) {
    }

    public record ResultOfRunTvm(String[] outMessages, Processing.DecodedOutput decoded, String account) {
    }

    public record ParamsOfRunGet(String account, String functionName, Map<String, Object> input, ExecutionOptions executionOptions, Boolean tupleListAsArray) {
    }

    public record ResultOfRunGet(Map<String, Object> output) {
    }

    public static enum TvmErrorCode {
        CanNotReadTransaction(401),
        CanNotReadBlockchainConfig(402),
        TransactionAborted(403),
        InternalError(404),
        ActionPhaseFailed(405),
        AccountCodeMissing(406),
        LowBalance(407),
        AccountFrozenOrDeleted(408),
        AccountMissing(409),
        UnknownExecutionError(410),
        InvalidInputStack(411),
        InvalidAccountBoc(412),
        InvalidMessageType(413),
        ContractExecutionError(414),
        AccountIsSuspended(415);

        private final Integer value;

        private TvmErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }

    public record TransactionFees(Long inMsgFwdFee, Long storageFee, Long gasFee, Long outMsgsFwdFee, Long totalAccountFees, Long totalOutput, Long extInMsgFee, Long totalFwdFees, Long accountFees) {
    }
}

