/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding.loader;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.deplant.java4ever.binding.loader.LibraryLoader;

public record AbsolutePathLoader(Path filepath) implements LibraryLoader
{
    private static Logger log = LoggerFactory.getLogger(AbsolutePathLoader.class);

    public AbsolutePathLoader {
        if (!filepath.isAbsolute()) {
            throw new IllegalArgumentException("Filepath of AbsolutePathLoader should be absolute. Filepath: " + String.valueOf(filepath));
        }
    }

    public AbsolutePathLoader(String filePathString) {
        this(Paths.get(filePathString, new String[0]));
    }

    public static AbsolutePathLoader ofUserDir(String fileName) {
        return new AbsolutePathLoader(System.getProperty("user.dir"));
    }

    public static AbsolutePathLoader ofSystemEnv(String envName) {
        String path = System.getenv(envName);
        log.trace("Path from ENV: " + path);
        return new AbsolutePathLoader(path);
    }

    @Override
    public void load() {
        System.load(this.filepath.toString());
    }
}

