/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;

public class Boc {
    public static ResultOfParse parseMessage(Context ctx, String boc) throws EverSdkException {
        return ctx.call("boc.parse_message", new ParamsOfParse(boc), ResultOfParse.class);
    }

    public static ResultOfParse parseTransaction(Context ctx, String boc) throws EverSdkException {
        return ctx.call("boc.parse_transaction", new ParamsOfParse(boc), ResultOfParse.class);
    }

    public static ResultOfParse parseAccount(Context ctx, String boc) throws EverSdkException {
        return ctx.call("boc.parse_account", new ParamsOfParse(boc), ResultOfParse.class);
    }

    public static ResultOfParse parseBlock(Context ctx, String boc) throws EverSdkException {
        return ctx.call("boc.parse_block", new ParamsOfParse(boc), ResultOfParse.class);
    }

    public static ResultOfParse parseShardstate(Context ctx, String boc, String id, Number workchainId) throws EverSdkException {
        return ctx.call("boc.parse_shardstate", new ParamsOfParseShardstate(boc, id, workchainId), ResultOfParse.class);
    }

    public static ResultOfGetBlockchainConfig getBlockchainConfig(Context ctx, String blockBoc) throws EverSdkException {
        return ctx.call("boc.get_blockchain_config", new ParamsOfGetBlockchainConfig(blockBoc), ResultOfGetBlockchainConfig.class);
    }

    public static ResultOfGetBocHash getBocHash(Context ctx, String boc) throws EverSdkException {
        return ctx.call("boc.get_boc_hash", new ParamsOfGetBocHash(boc), ResultOfGetBocHash.class);
    }

    public static ResultOfGetBocDepth getBocDepth(Context ctx, String boc) throws EverSdkException {
        return ctx.call("boc.get_boc_depth", new ParamsOfGetBocDepth(boc), ResultOfGetBocDepth.class);
    }

    public static ResultOfGetCodeFromTvc getCodeFromTvc(Context ctx, String tvc) throws EverSdkException {
        return ctx.call("boc.get_code_from_tvc", new ParamsOfGetCodeFromTvc(tvc), ResultOfGetCodeFromTvc.class);
    }

    public static ResultOfBocCacheGet cacheGet(Context ctx, String bocRef) throws EverSdkException {
        return ctx.call("boc.cache_get", new ParamsOfBocCacheGet(bocRef), ResultOfBocCacheGet.class);
    }

    public static ResultOfBocCacheSet cacheSet(Context ctx, String boc, BocCacheType cacheType) throws EverSdkException {
        return ctx.call("boc.cache_set", new ParamsOfBocCacheSet(boc, cacheType), ResultOfBocCacheSet.class);
    }

    public static void cacheUnpin(Context ctx, String pin, String bocRef) throws EverSdkException {
        ctx.callVoid("boc.cache_unpin", new ParamsOfBocCacheUnpin(pin, bocRef));
    }

    public static ResultOfEncodeBoc encodeBoc(Context ctx, BuilderOp[] builder, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.encode_boc", new ParamsOfEncodeBoc(builder, bocCache), ResultOfEncodeBoc.class);
    }

    public static ResultOfGetCodeSalt getCodeSalt(Context ctx, String code, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.get_code_salt", new ParamsOfGetCodeSalt(code, bocCache), ResultOfGetCodeSalt.class);
    }

    public static ResultOfSetCodeSalt setCodeSalt(Context ctx, String code, String salt, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.set_code_salt", new ParamsOfSetCodeSalt(code, salt, bocCache), ResultOfSetCodeSalt.class);
    }

    public static ResultOfDecodeTvc decodeTvc(Context ctx, String tvc, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.decode_tvc", new ParamsOfDecodeTvc(tvc, bocCache), ResultOfDecodeTvc.class);
    }

    public static ResultOfEncodeTvc encodeTvc(Context ctx, String code, String data, String library, Boolean tick, Boolean tock, Number splitDepth, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.encode_tvc", new ParamsOfEncodeTvc(code, data, library, tick, tock, splitDepth, bocCache), ResultOfEncodeTvc.class);
    }

    public static ResultOfEncodeExternalInMessage encodeExternalInMessage(Context ctx, String src, String dst, String init, String body, BocCacheType bocCache) throws EverSdkException {
        return ctx.call("boc.encode_external_in_message", new ParamsOfEncodeExternalInMessage(src, dst, init, body, bocCache), ResultOfEncodeExternalInMessage.class);
    }

    public static ResultOfGetCompilerVersion getCompilerVersion(Context ctx, String code) throws EverSdkException {
        return ctx.call("boc.get_compiler_version", new ParamsOfGetCompilerVersion(code), ResultOfGetCompilerVersion.class);
    }

    public record ParamsOfParse(String boc) {
    }

    public record ResultOfParse(Map<String, Object> parsed) {
    }

    public record ParamsOfParseShardstate(String boc, String id, Number workchainId) {
    }

    public record ParamsOfGetBlockchainConfig(String blockBoc) {
    }

    public record ResultOfGetBlockchainConfig(String configBoc) {
    }

    public record ParamsOfGetBocHash(String boc) {
    }

    public record ResultOfGetBocHash(String hash) {
    }

    public record ParamsOfGetBocDepth(String boc) {
    }

    public record ResultOfGetBocDepth(Number depth) {
    }

    public record ParamsOfGetCodeFromTvc(String tvc) {
    }

    public record ResultOfGetCodeFromTvc(String code) {
    }

    public record ParamsOfBocCacheGet(String bocRef) {
    }

    public record ResultOfBocCacheGet(String boc) {
    }

    public record ParamsOfBocCacheSet(String boc, BocCacheType cacheType) {
    }

    public static interface BocCacheType {
        public static final Unpinned UNPINNED = new Unpinned();

        public record Unpinned() implements BocCacheType
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record Pinned(String pin) implements BocCacheType
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public record ResultOfBocCacheSet(String bocRef) {
    }

    public record ParamsOfBocCacheUnpin(String pin, String bocRef) {
    }

    public record ParamsOfEncodeBoc(BuilderOp[] builder, BocCacheType bocCache) {
    }

    public static interface BuilderOp {

        public record Address(String address) implements BuilderOp
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record CellBoc(String boc) implements BuilderOp
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record Cell(BuilderOp[] builder) implements BuilderOp
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record BitString(String value) implements BuilderOp
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }

        public record Integer(Number size, String value) implements BuilderOp
        {
            @JsonProperty(value="type")
            public String type() {
                return this.getClass().getSimpleName();
            }
        }
    }

    public record ResultOfEncodeBoc(String boc) {
    }

    public record ParamsOfGetCodeSalt(String code, BocCacheType bocCache) {
    }

    public record ResultOfGetCodeSalt(String salt) {
    }

    public record ParamsOfSetCodeSalt(String code, String salt, BocCacheType bocCache) {
    }

    public record ResultOfSetCodeSalt(String code) {
    }

    public record ParamsOfDecodeTvc(String tvc, BocCacheType bocCache) {
    }

    public record ResultOfDecodeTvc(String code, String codeHash, Number codeDepth, String data, String dataHash, Number dataDepth, String library, Boolean tick, Boolean tock, Number splitDepth, String compilerVersion) {
    }

    public record ParamsOfEncodeTvc(String code, String data, String library, Boolean tick, Boolean tock, Number splitDepth, BocCacheType bocCache) {
    }

    public record ResultOfEncodeTvc(String tvc) {
    }

    public record ParamsOfEncodeExternalInMessage(String src, String dst, String init, String body, BocCacheType bocCache) {
    }

    public record ResultOfEncodeExternalInMessage(String message, String messageId) {
    }

    public record ParamsOfGetCompilerVersion(String code) {
    }

    public record ResultOfGetCompilerVersion(String version) {
    }
}

