/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import tech.carpentum.sdk.payment.model.PaymentInstruction;

@JsonClass(generateAdapter=false)
public class PaymentInstructionImpl
implements PaymentInstruction {
    private final String bankingService;
    private final String companyCode;
    private final int hashCode;
    private final String toString;

    @Override
    public String getBankingService() {
        return this.bankingService;
    }

    @Override
    public String getCompanyCode() {
        return this.companyCode;
    }

    private PaymentInstructionImpl(BuilderImpl builder) {
        this.bankingService = Objects.requireNonNull(builder.bankingService, "Property 'bankingService' is required.");
        this.companyCode = Objects.requireNonNull(builder.companyCode, "Property 'companyCode' is required.");
        this.hashCode = Objects.hash(this.bankingService, this.companyCode);
        this.toString = builder.type + "(bankingService=" + this.bankingService + ", companyCode=" + this.companyCode + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentInstructionImpl)) {
            return false;
        }
        PaymentInstructionImpl that = (PaymentInstructionImpl)obj;
        if (!this.bankingService.equals(that.bankingService)) {
            return false;
        }
        return this.companyCode.equals(that.companyCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PaymentInstruction.Builder {
        private String bankingService = null;
        private String companyCode = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PaymentInstruction");
        }

        @Override
        public BuilderImpl bankingService(String bankingService) {
            this.bankingService = bankingService;
            return this;
        }

        @Override
        public BuilderImpl companyCode(String companyCode) {
            this.companyCode = companyCode;
            return this;
        }

        @Override
        public PaymentInstructionImpl build() {
            return new PaymentInstructionImpl(this);
        }
    }
}

