/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.DuitNowPayMethodResponseImpl;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public interface DuitNowPayMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.DUITNOW;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public Money getMoney();

    @NotNull
    public Optional<Money> getMoneyRequired();

    @NotNull
    public String getMerchantName();

    @NotNull
    public String getReference();

    @NotNull
    public String getQrName();

    @NotNull
    public String getQrCode();

    @NotNull
    public Optional<PaymentOperatorIncoming> getPaymentOperator();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public static Builder builder(DuitNowPayMethodResponse copyOf) {
        Builder builder = DuitNowPayMethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.money(copyOf.getMoney());
        builder.moneyRequired(copyOf.getMoneyRequired().orElse(null));
        builder.merchantName(copyOf.getMerchantName());
        builder.reference(copyOf.getReference());
        builder.qrName(copyOf.getQrName());
        builder.qrCode(copyOf.getQrCode());
        builder.paymentOperator(copyOf.getPaymentOperator().orElse(null));
        builder.returnUrl(copyOf.getReturnUrl());
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new DuitNowPayMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        @NotNull
        public Builder idPayment(IdPayment var1);

        @NotNull
        public Builder money(Money var1);

        @NotNull
        public Builder moneyRequired(Money var1);

        @NotNull
        public Builder merchantName(String var1);

        @NotNull
        public Builder reference(String var1);

        @NotNull
        public Builder qrName(String var1);

        @NotNull
        public Builder qrCode(String var1);

        @NotNull
        public Builder paymentOperator(PaymentOperatorIncoming var1);

        @NotNull
        public Builder returnUrl(String var1);

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        @NotNull
        public DuitNowPayMethodResponse build();
    }
}

