/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PaymentRequestedImpl;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public interface PaymentRequested {
    @NotNull
    public Money getMoney();

    @NotNull
    public Optional<SegmentCode> getSegmentCode();

    @NotNull
    public static Builder builder(PaymentRequested copyOf) {
        Builder builder = PaymentRequested.builder();
        builder.money(copyOf.getMoney());
        builder.segmentCode(copyOf.getSegmentCode().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PaymentRequestedImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder money(Money var1);

        @NotNull
        public Builder segmentCode(SegmentCode var1);

        @NotNull
        public PaymentRequested build();
    }
}

