/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.api;

import com.squareup.moshi.Json;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.internal.generated.api.PaymentsApi;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiClient;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiResponse;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientException;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Informational;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Redirection;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestConfig;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestMethod;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ResponseExtensionsKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ResponseType;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Serializer;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerException;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Success;
import tech.carpentum.sdk.payment.model.CurrencyList;
import tech.carpentum.sdk.payment.model.PaymentMethodsList;
import tech.carpentum.sdk.payment.model.PaymentOperatorList;
import tech.carpentum.sdk.payment.model.PaymentOptionsList;
import tech.carpentum.sdk.payment.model.SegmentList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u000f2\u0006\u0010\t\u001a\u00020\nJ@\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003JF\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003JH\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u000f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u000f2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006("}, d2={"Ltech/carpentum/sdk/payment/internal/generated/api/PaymentsApi;", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient;", "basePath", "", "client", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "getCurrencies", "Ltech/carpentum/sdk/payment/model/CurrencyList;", "xAPIVersion", "", "getCurrenciesRequestConfig", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/RequestConfig;", "", "getCurrenciesWithHttpInfo", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiResponse;", "getPaymentMethods", "Ltech/carpentum/sdk/payment/model/PaymentMethodsList;", "getPaymentMethodsRequestConfig", "getPaymentMethodsWithHttpInfo", "getPaymentOperators", "Ltech/carpentum/sdk/payment/model/PaymentOperatorList;", "getPaymentOperatorsRequestConfig", "getPaymentOperatorsWithHttpInfo", "getPaymentOptions", "Ltech/carpentum/sdk/payment/model/PaymentOptionsList;", "paymentTypeCode", "Ltech/carpentum/sdk/payment/internal/generated/api/PaymentsApi$PaymentTypeCode_getPaymentOptions;", "paymentMethodCodes", "currencyCodes", "segmentCodes", "paymentOperatorCodes", "getPaymentOptionsRequestConfig", "getPaymentOptionsWithHttpInfo", "getSegments", "Ltech/carpentum/sdk/payment/model/SegmentList;", "getSegmentsRequestConfig", "getSegmentsWithHttpInfo", "Companion", "PaymentTypeCode_getPaymentOptions", "payment-client-v2"})
public class PaymentsApi
extends ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<String> defaultBasePath$delegate = LazyKt.lazy((Function0)Companion.defaultBasePath.2.INSTANCE);

    public PaymentsApi(@NotNull String basePath, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(basePath, client);
    }

    public /* synthetic */ PaymentsApi(String string, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = Companion.getDefaultBasePath();
        }
        this(string, okHttpClient);
    }

    @NotNull
    public final CurrencyList getCurrencies(int xAPIVersion) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<CurrencyList> localVarResponse = this.getCurrenciesWithHttpInfo(xAPIVersion);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                if (t != null) break;
                throw new NullPointerException("null cannot be cast to non-null type tech.carpentum.sdk.payment.model.CurrencyList");
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ClientError localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                ServerError localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (CurrencyList)t;
    }

    @NotNull
    public final ApiResponse<CurrencyList> getCurrenciesWithHttpInfo(int xAPIVersion) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getCurrenciesRequestConfig(xAPIVersion);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object2 = new char[]{'/'};
        Object $this$request_u24lambda_u2d7$iv = object2 = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object2));
        boolean bl = false;
        Object $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach232 = false;
        Object object3 = $this$forEach$iv$iv.entrySet().iterator();
        while (object3.hasNext()) {
            Unit query$iv = element$iv$iv = object3.next();
            boolean bl22 = false;
            Iterable iterable = query$iv.getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv2 : iterable) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl3 = false;
                $this$request_u24lambda_u2d7$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object2.build();
        object2 = localVariableConfig.getHeaders().get("Content-Type");
        if (object2 == null || object2.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object2 = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object2.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u2d7$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u2d7$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u2d7$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u2d7$iv == null || $this$request_u24lambda_u2d7$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String string3 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        $this$forEach$iv$iv = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv$iv, (String)"getDefault()");
        String $i$f$forEach232 = string3.toLowerCase((Locale)$this$forEach$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach232, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = $i$f$forEach232;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object3 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder3 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl7 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        $dstr$key$value$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl6 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder3.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder3.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder4 = bl22 = new FormBody.Builder(null, 1, null);
                    boolean bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        boolean bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder4.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                RequestBody requestBody;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder5 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder5.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder5.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder6 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder6.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder7 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder7.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder7.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder8 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder8.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder9 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder9.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        builder9.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder10 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder10.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object $this$request_u24lambda_u2d9$iv = $this$forEach$iv$iv = builder;
        boolean bl822 = false;
        Object $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach = false;
        Object bl22 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl22.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> header$iv = entry = bl22.next();
            boolean bl9 = false;
            $this$request_u24lambda_u2d9$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string4 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string4 == null) {
            string = null;
        } else {
            $this$forEach$iv$iv3 = StringsKt.substringBefore$default((String)string4, (String)";", null, (int)2, null);
            if ($this$forEach$iv$iv3 == null) {
                string = null;
            } else {
                bl22 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"getDefault()");
                String string5 = ((String)$this$forEach$iv$iv3).toLowerCase((Locale)bl22);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
                string = string5;
            }
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object;
            ApiClient bl822 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object = null;
                } else if (Intrinsics.areEqual(CurrencyList.class, File.class)) {
                    File file = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    file.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(file));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object = (CurrencyList)((Object)file);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi moshi2 = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object = _MoshiKotlinExtensionsKt.adapter((Moshi)moshi2, (KType)Reflection.nullableTypeOf(CurrencyList.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody == null ? null : responseBody.string(), response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody == null ? null : responseBody.string(), response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getCurrenciesRequestConfig(int xAPIVersion) {
        int n;
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getCurrenciesRequestConfig_u24lambda_u2d0 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getCurrenciesRequestConfig_u24lambda_u2d0));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Object>(requestMethod, "/currencies", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final PaymentMethodsList getPaymentMethods(int xAPIVersion) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<PaymentMethodsList> localVarResponse = this.getPaymentMethodsWithHttpInfo(xAPIVersion);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                if (t != null) break;
                throw new NullPointerException("null cannot be cast to non-null type tech.carpentum.sdk.payment.model.PaymentMethodsList");
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ClientError localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                ServerError localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (PaymentMethodsList)t;
    }

    @NotNull
    public final ApiResponse<PaymentMethodsList> getPaymentMethodsWithHttpInfo(int xAPIVersion) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getPaymentMethodsRequestConfig(xAPIVersion);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object2 = new char[]{'/'};
        Object $this$request_u24lambda_u2d7$iv = object2 = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object2));
        boolean bl = false;
        Object $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach232 = false;
        Object object3 = $this$forEach$iv$iv.entrySet().iterator();
        while (object3.hasNext()) {
            Unit query$iv = element$iv$iv = object3.next();
            boolean bl22 = false;
            Iterable iterable = query$iv.getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv2 : iterable) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl3 = false;
                $this$request_u24lambda_u2d7$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object2.build();
        object2 = localVariableConfig.getHeaders().get("Content-Type");
        if (object2 == null || object2.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object2 = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object2.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u2d7$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u2d7$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u2d7$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u2d7$iv == null || $this$request_u24lambda_u2d7$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String string3 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        $this$forEach$iv$iv = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv$iv, (String)"getDefault()");
        String $i$f$forEach232 = string3.toLowerCase((Locale)$this$forEach$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach232, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = $i$f$forEach232;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object3 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder3 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl7 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        $dstr$key$value$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl6 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder3.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder3.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder4 = bl22 = new FormBody.Builder(null, 1, null);
                    boolean bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        boolean bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder4.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                RequestBody requestBody;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder5 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder5.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder5.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder6 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder6.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder7 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder7.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder7.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder8 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder8.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder9 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder9.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        builder9.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder10 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder10.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object $this$request_u24lambda_u2d9$iv = $this$forEach$iv$iv = builder;
        boolean bl822 = false;
        Object $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach = false;
        Object bl22 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl22.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> header$iv = entry = bl22.next();
            boolean bl9 = false;
            $this$request_u24lambda_u2d9$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string4 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string4 == null) {
            string = null;
        } else {
            $this$forEach$iv$iv3 = StringsKt.substringBefore$default((String)string4, (String)";", null, (int)2, null);
            if ($this$forEach$iv$iv3 == null) {
                string = null;
            } else {
                bl22 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"getDefault()");
                String string5 = ((String)$this$forEach$iv$iv3).toLowerCase((Locale)bl22);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
                string = string5;
            }
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object;
            ApiClient bl822 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object = null;
                } else if (Intrinsics.areEqual(PaymentMethodsList.class, File.class)) {
                    File file = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    file.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(file));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object = (PaymentMethodsList)((Object)file);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi moshi2 = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object = _MoshiKotlinExtensionsKt.adapter((Moshi)moshi2, (KType)Reflection.nullableTypeOf(PaymentMethodsList.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody == null ? null : responseBody.string(), response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody == null ? null : responseBody.string(), response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getPaymentMethodsRequestConfig(int xAPIVersion) {
        int n;
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getPaymentMethodsRequestConfig_u24lambda_u2d1 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getPaymentMethodsRequestConfig_u24lambda_u2d1));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Object>(requestMethod, "/payment-methods", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final PaymentOperatorList getPaymentOperators(int xAPIVersion) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<PaymentOperatorList> localVarResponse = this.getPaymentOperatorsWithHttpInfo(xAPIVersion);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                if (t != null) break;
                throw new NullPointerException("null cannot be cast to non-null type tech.carpentum.sdk.payment.model.PaymentOperatorList");
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ClientError localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                ServerError localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (PaymentOperatorList)t;
    }

    @NotNull
    public final ApiResponse<PaymentOperatorList> getPaymentOperatorsWithHttpInfo(int xAPIVersion) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getPaymentOperatorsRequestConfig(xAPIVersion);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object2 = new char[]{'/'};
        Object $this$request_u24lambda_u2d7$iv = object2 = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object2));
        boolean bl = false;
        Object $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach232 = false;
        Object object3 = $this$forEach$iv$iv.entrySet().iterator();
        while (object3.hasNext()) {
            Unit query$iv = element$iv$iv = object3.next();
            boolean bl22 = false;
            Iterable iterable = query$iv.getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv2 : iterable) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl3 = false;
                $this$request_u24lambda_u2d7$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object2.build();
        object2 = localVariableConfig.getHeaders().get("Content-Type");
        if (object2 == null || object2.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object2 = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object2.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u2d7$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u2d7$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u2d7$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u2d7$iv == null || $this$request_u24lambda_u2d7$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String string3 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        $this$forEach$iv$iv = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv$iv, (String)"getDefault()");
        String $i$f$forEach232 = string3.toLowerCase((Locale)$this$forEach$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach232, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = $i$f$forEach232;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object3 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder3 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl7 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        $dstr$key$value$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl6 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder3.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder3.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder4 = bl22 = new FormBody.Builder(null, 1, null);
                    boolean bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        boolean bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder4.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                RequestBody requestBody;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder5 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder5.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder5.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder6 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder6.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder7 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder7.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder7.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder8 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder8.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder9 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder9.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        builder9.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder10 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder10.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object $this$request_u24lambda_u2d9$iv = $this$forEach$iv$iv = builder;
        boolean bl822 = false;
        Object $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach = false;
        Object bl22 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl22.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> header$iv = entry = bl22.next();
            boolean bl9 = false;
            $this$request_u24lambda_u2d9$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string4 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string4 == null) {
            string = null;
        } else {
            $this$forEach$iv$iv3 = StringsKt.substringBefore$default((String)string4, (String)";", null, (int)2, null);
            if ($this$forEach$iv$iv3 == null) {
                string = null;
            } else {
                bl22 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"getDefault()");
                String string5 = ((String)$this$forEach$iv$iv3).toLowerCase((Locale)bl22);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
                string = string5;
            }
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object;
            ApiClient bl822 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object = null;
                } else if (Intrinsics.areEqual(PaymentOperatorList.class, File.class)) {
                    File file = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    file.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(file));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object = (PaymentOperatorList)((Object)file);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi moshi2 = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object = _MoshiKotlinExtensionsKt.adapter((Moshi)moshi2, (KType)Reflection.nullableTypeOf(PaymentOperatorList.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody == null ? null : responseBody.string(), response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody == null ? null : responseBody.string(), response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getPaymentOperatorsRequestConfig(int xAPIVersion) {
        int n;
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getPaymentOperatorsRequestConfig_u24lambda_u2d2 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getPaymentOperatorsRequestConfig_u24lambda_u2d2));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Object>(requestMethod, "/payment-operators", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final PaymentOptionsList getPaymentOptions(int xAPIVersion, @Nullable PaymentTypeCode_getPaymentOptions paymentTypeCode, @Nullable String paymentMethodCodes, @Nullable String currencyCodes, @Nullable String segmentCodes, @Nullable String paymentOperatorCodes) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<PaymentOptionsList> localVarResponse = this.getPaymentOptionsWithHttpInfo(xAPIVersion, paymentTypeCode, paymentMethodCodes, currencyCodes, segmentCodes, paymentOperatorCodes);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                if (t != null) break;
                throw new NullPointerException("null cannot be cast to non-null type tech.carpentum.sdk.payment.model.PaymentOptionsList");
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ClientError localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                ServerError localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (PaymentOptionsList)t;
    }

    @NotNull
    public final ApiResponse<PaymentOptionsList> getPaymentOptionsWithHttpInfo(int xAPIVersion, @Nullable PaymentTypeCode_getPaymentOptions paymentTypeCode, @Nullable String paymentMethodCodes, @Nullable String currencyCodes, @Nullable String segmentCodes, @Nullable String paymentOperatorCodes) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getPaymentOptionsRequestConfig(xAPIVersion, paymentTypeCode, paymentMethodCodes, currencyCodes, segmentCodes, paymentOperatorCodes);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object2 = new char[]{'/'};
        Object $this$request_u24lambda_u2d7$iv = object2 = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object2));
        boolean bl = false;
        Object $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach232 = false;
        Object object3 = $this$forEach$iv$iv.entrySet().iterator();
        while (object3.hasNext()) {
            Unit query$iv = element$iv$iv = object3.next();
            boolean bl22 = false;
            Iterable iterable = query$iv.getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv2 : iterable) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl3 = false;
                $this$request_u24lambda_u2d7$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object2.build();
        object2 = localVariableConfig.getHeaders().get("Content-Type");
        if (object2 == null || object2.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object2 = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object2.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u2d7$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u2d7$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u2d7$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u2d7$iv == null || $this$request_u24lambda_u2d7$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String string3 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        $this$forEach$iv$iv = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv$iv, (String)"getDefault()");
        String $i$f$forEach232 = string3.toLowerCase((Locale)$this$forEach$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach232, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = $i$f$forEach232;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object3 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder3 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl7 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        $dstr$key$value$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl6 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder3.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder3.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder4 = bl22 = new FormBody.Builder(null, 1, null);
                    boolean bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        boolean bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder4.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                RequestBody requestBody;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder5 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder5.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder5.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder6 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder6.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder7 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder7.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder7.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder8 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder8.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder9 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder9.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        builder9.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder10 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder10.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object $this$request_u24lambda_u2d9$iv = $this$forEach$iv$iv = builder;
        boolean bl822 = false;
        Object $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach = false;
        Object bl22 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl22.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> header$iv = entry = bl22.next();
            boolean bl9 = false;
            $this$request_u24lambda_u2d9$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string4 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string4 == null) {
            string = null;
        } else {
            $this$forEach$iv$iv3 = StringsKt.substringBefore$default((String)string4, (String)";", null, (int)2, null);
            if ($this$forEach$iv$iv3 == null) {
                string = null;
            } else {
                bl22 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"getDefault()");
                String string5 = ((String)$this$forEach$iv$iv3).toLowerCase((Locale)bl22);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
                string = string5;
            }
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object;
            ApiClient bl822 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object = null;
                } else if (Intrinsics.areEqual(PaymentOptionsList.class, File.class)) {
                    File file = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    file.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(file));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object = (PaymentOptionsList)((Object)file);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi moshi2 = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object = _MoshiKotlinExtensionsKt.adapter((Moshi)moshi2, (KType)Reflection.nullableTypeOf(PaymentOptionsList.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody == null ? null : responseBody.string(), response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody == null ? null : responseBody.string(), response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getPaymentOptionsRequestConfig(int xAPIVersion, @Nullable PaymentTypeCode_getPaymentOptions paymentTypeCode, @Nullable String paymentMethodCodes, @Nullable String currencyCodes, @Nullable String segmentCodes, @Nullable String paymentOperatorCodes) {
        int n;
        Map map;
        Object localVariableBody = null;
        Map $this$getPaymentOptionsRequestConfig_u24lambda_u2d3 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (paymentTypeCode != null) {
            $this$getPaymentOptionsRequestConfig_u24lambda_u2d3.put("paymentTypeCode", CollectionsKt.listOf((Object)paymentTypeCode.toString()));
        }
        if (paymentMethodCodes != null) {
            $this$getPaymentOptionsRequestConfig_u24lambda_u2d3.put("paymentMethodCodes", CollectionsKt.listOf((Object)paymentMethodCodes.toString()));
        }
        if (currencyCodes != null) {
            $this$getPaymentOptionsRequestConfig_u24lambda_u2d3.put("currencyCodes", CollectionsKt.listOf((Object)currencyCodes.toString()));
        }
        if (segmentCodes != null) {
            $this$getPaymentOptionsRequestConfig_u24lambda_u2d3.put("segmentCodes", CollectionsKt.listOf((Object)segmentCodes.toString()));
        }
        if (paymentOperatorCodes != null) {
            $this$getPaymentOptionsRequestConfig_u24lambda_u2d3.put("paymentOperatorCodes", CollectionsKt.listOf((Object)paymentOperatorCodes.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getPaymentOptionsRequestConfig_u24lambda_u2d4 = n = xAPIVersion;
        boolean bl2 = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getPaymentOptionsRequestConfig_u24lambda_u2d4));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Object>(requestMethod, "/payment-options", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final SegmentList getSegments(int xAPIVersion) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<SegmentList> localVarResponse = this.getSegmentsWithHttpInfo(xAPIVersion);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                t = ((Success)localVarResponse).getData();
                if (t != null) break;
                throw new NullPointerException("null cannot be cast to non-null type tech.carpentum.sdk.payment.model.SegmentList");
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                ClientError localVarError = (ClientError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Client error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                ServerError localVarError = (ServerError)localVarResponse;
                StringBuilder stringBuilder = new StringBuilder().append("Server error : ").append(localVarError.getStatusCode()).append(' ');
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException(stringBuilder.append(string).toString(), localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (SegmentList)t;
    }

    @NotNull
    public final ApiResponse<SegmentList> getSegmentsWithHttpInfo(int xAPIVersion) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getSegmentsRequestConfig(xAPIVersion);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object2 = new char[]{'/'};
        Object $this$request_u24lambda_u2d7$iv = object2 = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object2));
        boolean bl = false;
        Object $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach232 = false;
        Object object3 = $this$forEach$iv$iv.entrySet().iterator();
        while (object3.hasNext()) {
            Unit query$iv = element$iv$iv = object3.next();
            boolean bl22 = false;
            Iterable iterable = query$iv.getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv2 : iterable) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl3 = false;
                $this$request_u24lambda_u2d7$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object2.build();
        object2 = localVariableConfig.getHeaders().get("Content-Type");
        if (object2 == null || object2.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object2 = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object2.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u2d7$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u2d7$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u2d7$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u2d7$iv == null || $this$request_u24lambda_u2d7$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String string3 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        $this$forEach$iv$iv = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv$iv, (String)"getDefault()");
        String $i$f$forEach232 = string3.toLowerCase((Locale)$this$forEach$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach232, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = $i$f$forEach232;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object3 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder3 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl7 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        $dstr$key$value$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl6 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder3.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder3.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder4 = bl22 = new FormBody.Builder(null, 1, null);
                    boolean bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        boolean bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder4.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                RequestBody requestBody;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder5 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder5.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder5.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder6 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder6.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder7 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder7.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        builder7.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder8 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder8.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                Map.Entry $dstr$key$value$iv$iv;
                Map $this$forEach$iv$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl22;
                    MultipartBody.Builder builder9 = bl22 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + '\"'};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            builder9.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + '\"'};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        builder9.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl22;
                    FormBody.Builder builder10 = bl22 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Unit unit = content$iv$iv;
                    if (unit == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv$iv = (Map)unit;
                    boolean $i$f$forEach = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        $dstr$key$value$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        key$iv$iv = (String)$dstr$key$value$iv$iv.getKey();
                        value$iv$iv = $dstr$key$value$iv$iv.getValue();
                        builder10.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl22.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String bl22 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"moshi.adapter(T::class.java).toJson(content)");
                        requestBody = RequestBody.Companion.create(bl22, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object $this$request_u24lambda_u2d9$iv = $this$forEach$iv$iv = builder;
        boolean bl822 = false;
        Object $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach = false;
        Object bl22 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl22.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> header$iv = entry = bl22.next();
            boolean bl9 = false;
            $this$request_u24lambda_u2d9$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string4 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string4 == null) {
            string = null;
        } else {
            $this$forEach$iv$iv3 = StringsKt.substringBefore$default((String)string4, (String)";", null, (int)2, null);
            if ($this$forEach$iv$iv3 == null) {
                string = null;
            } else {
                bl22 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)bl22, (String)"getDefault()");
                String string5 = ((String)$this$forEach$iv$iv3).toLowerCase((Locale)bl22);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
                string = string5;
            }
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object;
            ApiClient bl822 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object = null;
                } else if (Intrinsics.areEqual(SegmentList.class, File.class)) {
                    File file = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    file.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(file));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object = (SegmentList)((Object)file);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi moshi2 = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object = _MoshiKotlinExtensionsKt.adapter((Moshi)moshi2, (KType)Reflection.nullableTypeOf(SegmentList.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody == null ? null : responseBody.string(), response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody == null ? null : responseBody.string(), response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getSegmentsRequestConfig(int xAPIVersion) {
        int n;
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getSegmentsRequestConfig_u24lambda_u2d5 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getSegmentsRequestConfig_u24lambda_u2d5));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Object>(requestMethod, "/segments", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public static final String getDefaultBasePath() {
        return Companion.getDefaultBasePath();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/api/PaymentsApi$Companion;", "", "()V", "defaultBasePath", "", "getDefaultBasePath$annotations", "getDefaultBasePath", "()Ljava/lang/String;", "defaultBasePath$delegate", "Lkotlin/Lazy;", "payment-client-v2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultBasePath() {
            Lazy lazy = defaultBasePath$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-defaultBasePath>(...)");
            return (String)object;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultBasePath$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/api/PaymentsApi$PaymentTypeCode_getPaymentOptions;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "PAYIN", "PAYOUT", "payment-client-v2"})
    public static final class PaymentTypeCode_getPaymentOptions
    extends Enum<PaymentTypeCode_getPaymentOptions> {
        @NotNull
        private final String value;
        @Json(name="PAYIN")
        public static final /* enum */ PaymentTypeCode_getPaymentOptions PAYIN = new PaymentTypeCode_getPaymentOptions("PAYIN");
        @Json(name="PAYOUT")
        public static final /* enum */ PaymentTypeCode_getPaymentOptions PAYOUT = new PaymentTypeCode_getPaymentOptions("PAYOUT");
        private static final /* synthetic */ PaymentTypeCode_getPaymentOptions[] $VALUES;

        private PaymentTypeCode_getPaymentOptions(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static PaymentTypeCode_getPaymentOptions[] values() {
            return (PaymentTypeCode_getPaymentOptions[])$VALUES.clone();
        }

        public static PaymentTypeCode_getPaymentOptions valueOf(String value) {
            return Enum.valueOf(PaymentTypeCode_getPaymentOptions.class, value);
        }

        static {
            $VALUES = paymentTypeCode_getPaymentOptionsArray = new PaymentTypeCode_getPaymentOptions[]{PaymentTypeCode_getPaymentOptions.PAYIN, PaymentTypeCode_getPaymentOptions.PAYOUT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            nArray[ResponseType.Success.ordinal()] = 1;
            nArray[ResponseType.Informational.ordinal()] = 2;
            nArray[ResponseType.Redirection.ordinal()] = 3;
            nArray[ResponseType.ClientError.ordinal()] = 4;
            nArray[ResponseType.ServerError.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

