/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.AuthTokenRequestImpl;
import tech.carpentum.sdk.payment.internal.generated.model.AuthTokenRequestJson;
import tech.carpentum.sdk.payment.model.AuthTokenRequest;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/model/AuthTokenRequestJsonAdapter;", "", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/AuthTokenRequest;", "json", "Ltech/carpentum/sdk/payment/internal/generated/model/AuthTokenRequestJson;", "fromJsonImpl", "Ltech/carpentum/sdk/payment/internal/generated/model/AuthTokenRequestImpl;", "model", "toJson", "toJsonImpl", "impl", "payment-client-v2"})
public final class AuthTokenRequestJsonAdapter {
    @FromJson
    @NotNull
    public final AuthTokenRequest fromJson(@NotNull AuthTokenRequestJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Object object = AuthTokenRequest.builder();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder()");
        AuthTokenRequest.Builder builder = object;
        builder.merchantCode(json.getMerchantCode());
        builder.secret(json.getSecret());
        builder.validitySecs(json.getValiditySecs());
        List<String> list = json.getOperations();
        builder.operations(list == null ? null : CollectionsKt.toList((Iterable)list));
        builder.money(json.getMoney());
        object = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.build()");
        return object;
    }

    @ToJson
    @NotNull
    public final AuthTokenRequestJson toJson(@NotNull AuthTokenRequest model) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        AuthTokenRequestJson json = new AuthTokenRequestJson();
        json.setMerchantCode(model.getMerchantCode());
        json.setSecret(model.getSecret());
        json.setValiditySecs(model.getValiditySecs().orElse(null));
        AuthTokenRequestJson authTokenRequestJson = json;
        Collection collection2 = model.getOperations();
        if (collection2.isEmpty()) {
            AuthTokenRequestJson authTokenRequestJson2 = authTokenRequestJson;
            boolean bl = false;
            collection = null;
            authTokenRequestJson = authTokenRequestJson2;
        } else {
            collection = collection2;
        }
        authTokenRequestJson.setOperations((List)collection);
        json.setMoney(model.getMoney().orElse(null));
        return json;
    }

    @FromJson
    @NotNull
    public final AuthTokenRequestImpl fromJsonImpl(@NotNull AuthTokenRequest model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (AuthTokenRequestImpl)model;
    }

    @ToJson
    @NotNull
    public final AuthTokenRequest toJsonImpl(@NotNull AuthTokenRequestImpl impl) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        return impl;
    }
}

