/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.P2AV2MethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountResponseP2AV2;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentAddress;

@JsonClass(generateAdapter=false)
public interface P2AV2MethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.P2A_V2;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public AccountResponseP2AV2 getAccount();

    @NotNull
    public Money getMoney();

    @NotNull
    public String getMerchantName();

    @NotNull
    public PaymentAddress getPaymentAddress();

    @NotNull
    public String getQrName();

    @NotNull
    public String getQrCode();

    @NotNull
    public String getReference();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public static Builder builder(P2AV2MethodResponse copyOf) {
        Builder builder = P2AV2MethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.account(copyOf.getAccount());
        builder.money(copyOf.getMoney());
        builder.merchantName(copyOf.getMerchantName());
        builder.paymentAddress(copyOf.getPaymentAddress());
        builder.qrName(copyOf.getQrName());
        builder.qrCode(copyOf.getQrCode());
        builder.reference(copyOf.getReference());
        builder.returnUrl(copyOf.getReturnUrl());
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new P2AV2MethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        @NotNull
        public Builder idPayment(IdPayment var1);

        @NotNull
        public Builder account(AccountResponseP2AV2 var1);

        @NotNull
        public Builder money(Money var1);

        @NotNull
        public Builder merchantName(String var1);

        @NotNull
        public Builder paymentAddress(PaymentAddress var1);

        @NotNull
        public Builder qrName(String var1);

        @NotNull
        public Builder qrCode(String var1);

        @NotNull
        public Builder reference(String var1);

        @NotNull
        public Builder returnUrl(String var1);

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        @NotNull
        public P2AV2MethodResponse build();
    }
}

