/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PayoutImpl;
import tech.carpentum.sdk.payment.internal.generated.model.PayoutJson;
import tech.carpentum.sdk.payment.model.Payout;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/model/PayoutJsonAdapter;", "", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/Payout;", "json", "Ltech/carpentum/sdk/payment/internal/generated/model/PayoutJson;", "fromJsonImpl", "Ltech/carpentum/sdk/payment/internal/generated/model/PayoutImpl;", "model", "toJson", "toJsonImpl", "impl", "payment-client-v2"})
public final class PayoutJsonAdapter {
    @FromJson
    @NotNull
    public final Payout fromJson(@NotNull PayoutJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Payout.Builder builder = Payout.builder();
        builder.paymentRequested(json.getPaymentRequested());
        builder.paymentMethod(json.getPaymentMethod());
        builder.callbackUrl(json.getCallbackUrl());
        builder.customerIp(json.getCustomerIp());
        Payout payout = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)payout, (String)"builder.build()");
        return payout;
    }

    @ToJson
    @NotNull
    public final PayoutJson toJson(@NotNull Payout model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        PayoutJson json = new PayoutJson();
        json.setPaymentRequested(model.getPaymentRequested());
        json.setPaymentMethod(model.getPaymentMethod());
        json.setCallbackUrl(model.getCallbackUrl().orElse(null));
        json.setCustomerIp(model.getCustomerIp().orElse(null));
        return json;
    }

    @FromJson
    @NotNull
    public final PayoutImpl fromJsonImpl(@NotNull Payout model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (PayoutImpl)model;
    }

    @ToJson
    @NotNull
    public final Payout toJsonImpl(@NotNull PayoutImpl impl) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        return impl;
    }
}

