/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.CryptoOfflineMethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountResponseCryptoOffline;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;

@JsonClass(generateAdapter=false)
public interface CryptoOfflineMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.CRYPTO_OFFLINE;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public AccountResponseCryptoOffline getAccount();

    @NotNull
    public Money getMoney();

    @NotNull
    public String getMerchantName();

    @NotNull
    public String getReference();

    @NotNull
    public String getQrName();

    @NotNull
    public String getQrCode();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    public static Builder builder() {
        return new CryptoOfflineMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        public Builder idPayin(IdPayin var1);

        public Builder account(AccountResponseCryptoOffline var1);

        public Builder money(Money var1);

        public Builder merchantName(String var1);

        public Builder reference(String var1);

        public Builder qrName(String var1);

        public Builder qrCode(String var1);

        public Builder returnUrl(String var1);

        public Builder acceptedAt(OffsetDateTime var1);

        public Builder expireAt(OffsetDateTime var1);

        public CryptoOfflineMethodResponse build();
    }
}

