/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.BalanceImpl;
import tech.carpentum.sdk.payment.model.CurrencyCode;

@JsonClass(generateAdapter=false)
public interface Balance {
    @NotNull
    public CurrencyCode getCurrencyCode();

    @NotNull
    public BigDecimal getBalance();

    @NotNull
    public BigDecimal getAvailableBalance();

    @NotNull
    public BigDecimal getPendingSettlementAmount();

    @NotNull
    public BigDecimal getPendingPayoutAmount();

    @NotNull
    public OffsetDateTime getLastBalanceMovement();

    public static Builder builder() {
        return new BalanceImpl.BuilderImpl();
    }

    public static interface Builder {
        public Builder currencyCode(CurrencyCode var1);

        public Builder balance(BigDecimal var1);

        public Builder availableBalance(BigDecimal var1);

        public Builder pendingSettlementAmount(BigDecimal var1);

        public Builder pendingPayoutAmount(BigDecimal var1);

        public Builder lastBalanceMovement(OffsetDateTime var1);

        public Balance build();
    }
}

