/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountPayinRequestQrisPay;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.QrisPayMethod;

@JsonClass(generateAdapter=false)
public class QrisPayMethodImpl
implements QrisPayMethod {
    private final Optional<AccountPayinRequestQrisPay> account;
    private final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    @Override
    @NotNull
    public Optional<AccountPayinRequestQrisPay> getAccount() {
        return this.account;
    }

    @Override
    @NotNull
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    @NotNull
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private QrisPayMethodImpl(BuilderImpl builder) {
        this.account = Optional.ofNullable(builder.account);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(this.account, this.emailAddress);
        this.toString = "QrisPayMethod(account=" + this.account + ", emailAddress=" + this.emailAddress + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QrisPayMethod)) {
            return false;
        }
        QrisPayMethodImpl that = (QrisPayMethodImpl)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        return this.emailAddress.equals(that.emailAddress);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements QrisPayMethod.Builder {
        private AccountPayinRequestQrisPay account = null;
        private String emailAddress = null;

        @Override
        public BuilderImpl account(AccountPayinRequestQrisPay account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public QrisPayMethodImpl build() {
            return new QrisPayMethodImpl(this);
        }
    }
}

