/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public class PaymentRequestedImpl
implements PaymentRequested {
    private final Money money;
    private final Optional<SegmentCode> segmentCode;
    private final int hashCode;
    private final String toString;

    @Override
    @NotNull
    public Money getMoney() {
        return this.money;
    }

    @Override
    @NotNull
    public Optional<SegmentCode> getSegmentCode() {
        return this.segmentCode;
    }

    private PaymentRequestedImpl(BuilderImpl builder) {
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.segmentCode = Optional.ofNullable(builder.segmentCode);
        this.hashCode = Objects.hash(this.money, this.segmentCode);
        this.toString = "PaymentRequested(money=" + this.money + ", segmentCode=" + this.segmentCode + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentRequested)) {
            return false;
        }
        PaymentRequestedImpl that = (PaymentRequestedImpl)obj;
        if (!this.money.equals(that.money)) {
            return false;
        }
        return this.segmentCode.equals(that.segmentCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PaymentRequested.Builder {
        private Money money = null;
        private SegmentCode segmentCode = null;

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public BuilderImpl segmentCode(SegmentCode segmentCode) {
            this.segmentCode = segmentCode;
            return this;
        }

        @Override
        public PaymentRequestedImpl build() {
            return new PaymentRequestedImpl(this);
        }
    }
}

