/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountPayinRequestOffline;
import tech.carpentum.sdk.payment.model.OfflineMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class OfflineMethodImpl
implements OfflineMethod {
    private final AccountPayinRequestOffline account;
    private final Optional<String> paymentOperatorCode;
    private final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    @Override
    @NotNull
    public AccountPayinRequestOffline getAccount() {
        return this.account;
    }

    @Override
    @NotNull
    public Optional<String> getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    @NotNull
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    @NotNull
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private OfflineMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.paymentOperatorCode = Optional.ofNullable(builder.paymentOperatorCode);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(this.account, this.paymentOperatorCode, this.emailAddress);
        this.toString = "OfflineMethod(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ", emailAddress=" + this.emailAddress + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OfflineMethod)) {
            return false;
        }
        OfflineMethodImpl that = (OfflineMethodImpl)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.paymentOperatorCode.equals(that.paymentOperatorCode)) {
            return false;
        }
        return this.emailAddress.equals(that.emailAddress);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements OfflineMethod.Builder {
        private AccountPayinRequestOffline account = null;
        private String paymentOperatorCode = null;
        private String emailAddress = null;

        @Override
        public BuilderImpl account(AccountPayinRequestOffline account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public OfflineMethodImpl build() {
            return new OfflineMethodImpl(this);
        }
    }
}

