/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.math.BigDecimal;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.MoneyRequired;

@JsonClass(generateAdapter=false)
public class MoneyRequiredImpl
implements MoneyRequired {
    private final BigDecimal amount;
    private final CurrencyCode currencyCode;
    private final int hashCode;
    private final String toString;

    @Override
    @NotNull
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    @NotNull
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    private MoneyRequiredImpl(BuilderImpl builder) {
        this.amount = Objects.requireNonNull(builder.amount, "Property 'amount' is required.");
        this.currencyCode = Objects.requireNonNull(builder.currencyCode, "Property 'currencyCode' is required.");
        this.hashCode = Objects.hash(this.amount, this.currencyCode);
        this.toString = "MoneyRequired(amount=" + this.amount + ", currencyCode=" + this.currencyCode + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MoneyRequired)) {
            return false;
        }
        MoneyRequiredImpl that = (MoneyRequiredImpl)obj;
        if (!this.amount.equals(that.amount)) {
            return false;
        }
        return this.currencyCode.equals(that.currencyCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements MoneyRequired.Builder {
        private BigDecimal amount = null;
        private CurrencyCode currencyCode = null;

        @Override
        public BuilderImpl amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        @Override
        public BuilderImpl currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public MoneyRequiredImpl build() {
            return new MoneyRequiredImpl(this);
        }
    }
}

