/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonClass(generateAdapter=false)
public class Redirection {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    @NotNull
    public final String method;
    @NotNull
    public final String url;
    @NotNull
    public final Optional<String> data;
    private final int hashCode;
    private final String toString;

    private Redirection(Builder builder) {
        this.method = Objects.requireNonNull(builder.method, "Property 'method' is required.");
        this.url = Objects.requireNonNull(builder.url, "Property 'url' is required.");
        this.data = Optional.ofNullable(builder.data);
        this.hashCode = Objects.hash(this.method, this.url, this.data);
        this.toString = "Redirection(method=" + this.method + ", url=" + this.url + ", data=" + this.data + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Redirection)) {
            return false;
        }
        Redirection that = (Redirection)obj;
        if (!this.method.equals(that.method)) {
            return false;
        }
        if (!this.url.equals(that.url)) {
            return false;
        }
        return this.data.equals(that.data);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String method = null;
        private String url = null;
        private String data = null;

        private Builder() {
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            return this;
        }

        public Redirection build() {
            return new Redirection(this);
        }
    }
}

