/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.CustomerTransactionFee;

@JsonClass(generateAdapter=false)
public class PaymentOperator {
    @NotNull
    public final String code;
    @NotNull
    public final String name;
    @NotNull
    public final Optional<CustomerTransactionFee> customerTransactionFee;
    private final int hashCode;
    private final String toString;

    private PaymentOperator(Builder builder) {
        this.code = Objects.requireNonNull(builder.code, "Property 'code' is required.");
        this.name = Objects.requireNonNull(builder.name, "Property 'name' is required.");
        this.customerTransactionFee = Optional.ofNullable(builder.customerTransactionFee);
        this.hashCode = Objects.hash(this.code, this.name, this.customerTransactionFee);
        this.toString = "PaymentOperator(code=" + this.code + ", name=" + this.name + ", customerTransactionFee=" + this.customerTransactionFee + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentOperator)) {
            return false;
        }
        PaymentOperator that = (PaymentOperator)obj;
        if (!this.code.equals(that.code)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.customerTransactionFee.equals(that.customerTransactionFee);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String code = null;
        private String name = null;
        private CustomerTransactionFee customerTransactionFee = null;

        private Builder() {
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder customerTransactionFee(CustomerTransactionFee customerTransactionFee) {
            this.customerTransactionFee = customerTransactionFee;
            return this;
        }

        public PaymentOperator build() {
            return new PaymentOperator(this);
        }
    }
}

