/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.PaymentRequested;

@JsonClass(generateAdapter=false)
public class Payin {
    @NotNull
    public final PaymentRequested paymentRequested;
    @NotNull
    public final PayinMethod paymentMethod;
    @NotNull
    public final Optional<String> callbackUrl;
    @NotNull
    public final String returnUrl;
    @NotNull
    public final Optional<String> customerIp;
    private final int hashCode;
    private final String toString;

    private Payin(Builder builder) {
        this.paymentRequested = Objects.requireNonNull(builder.paymentRequested, "Property 'paymentRequested' is required.");
        this.paymentMethod = Objects.requireNonNull(builder.paymentMethod, "Property 'paymentMethod' is required.");
        this.callbackUrl = Optional.ofNullable(builder.callbackUrl);
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.customerIp = Optional.ofNullable(builder.customerIp);
        this.hashCode = Objects.hash(this.paymentRequested, this.paymentMethod, this.callbackUrl, this.returnUrl, this.customerIp);
        this.toString = "Payin(paymentRequested=" + this.paymentRequested + ", paymentMethod=" + this.paymentMethod + ", callbackUrl=" + this.callbackUrl + ", returnUrl=" + this.returnUrl + ", customerIp=" + this.customerIp + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Payin)) {
            return false;
        }
        Payin that = (Payin)obj;
        if (!this.paymentRequested.equals(that.paymentRequested)) {
            return false;
        }
        if (!this.paymentMethod.equals(that.paymentMethod)) {
            return false;
        }
        if (!this.callbackUrl.equals(that.callbackUrl)) {
            return false;
        }
        if (!this.returnUrl.equals(that.returnUrl)) {
            return false;
        }
        return this.customerIp.equals(that.customerIp);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private PaymentRequested paymentRequested = null;
        private PayinMethod paymentMethod = null;
        private String callbackUrl = null;
        private String returnUrl = null;
        private String customerIp = null;

        private Builder() {
        }

        public Builder paymentRequested(PaymentRequested paymentRequested) {
            this.paymentRequested = paymentRequested;
            return this;
        }

        public Builder paymentMethod(PayinMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        public Builder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder customerIp(String customerIp) {
            this.customerIp = customerIp;
            return this;
        }

        public Payin build() {
            return new Payin(this);
        }
    }
}

