/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountPayinRequestOnline;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class OnlineMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.ONLINE;
    @NotNull
    public final Optional<AccountPayinRequestOnline> account;
    @NotNull
    public final Optional<String> paymentOperatorCode;
    @NotNull
    public final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    private OnlineMethod(Builder builder) {
        super(PAYMENT_METHOD_CODE);
        this.account = Optional.ofNullable(builder.account);
        this.paymentOperatorCode = Optional.ofNullable(builder.paymentOperatorCode);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(new Object[]{this.account, this.paymentOperatorCode, this.emailAddress, this.paymentMethodCode});
        this.toString = "OnlineMethod(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ", emailAddress=" + this.emailAddress + ", paymentMethodCode=" + (Object)((Object)this.paymentMethodCode) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnlineMethod)) {
            return false;
        }
        OnlineMethod that = (OnlineMethod)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.paymentOperatorCode.equals(that.paymentOperatorCode)) {
            return false;
        }
        if (!this.emailAddress.equals(that.emailAddress)) {
            return false;
        }
        return this.paymentMethodCode.equals((Object)that.paymentMethodCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AccountPayinRequestOnline account = null;
        private String paymentOperatorCode = null;
        private String emailAddress = null;

        private Builder() {
        }

        public Builder account(AccountPayinRequestOnline account) {
            this.account = account;
            return this;
        }

        public Builder paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public OnlineMethod build() {
            return new OnlineMethod(this);
        }
    }
}

