/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.CurrencyCode;

@JsonClass(generateAdapter=false)
public class Balance {
    @NotNull
    public final CurrencyCode currencyCode;
    @NotNull
    public final BigDecimal balance;
    @NotNull
    public final BigDecimal availableBalance;
    @NotNull
    public final BigDecimal pendingSettlementAmount;
    @NotNull
    public final BigDecimal pendingPayoutAmount;
    @NotNull
    public final OffsetDateTime lastBalanceMovement;
    private final int hashCode;
    private final String toString;

    private Balance(Builder builder) {
        this.currencyCode = Objects.requireNonNull(builder.currencyCode, "Property 'currencyCode' is required.");
        this.balance = Objects.requireNonNull(builder.balance, "Property 'balance' is required.");
        this.availableBalance = Objects.requireNonNull(builder.availableBalance, "Property 'availableBalance' is required.");
        this.pendingSettlementAmount = Objects.requireNonNull(builder.pendingSettlementAmount, "Property 'pendingSettlementAmount' is required.");
        this.pendingPayoutAmount = Objects.requireNonNull(builder.pendingPayoutAmount, "Property 'pendingPayoutAmount' is required.");
        this.lastBalanceMovement = Objects.requireNonNull(builder.lastBalanceMovement, "Property 'lastBalanceMovement' is required.");
        this.hashCode = Objects.hash(this.currencyCode, this.balance, this.availableBalance, this.pendingSettlementAmount, this.pendingPayoutAmount, this.lastBalanceMovement);
        this.toString = "Balance(currencyCode=" + this.currencyCode + ", balance=" + this.balance + ", availableBalance=" + this.availableBalance + ", pendingSettlementAmount=" + this.pendingSettlementAmount + ", pendingPayoutAmount=" + this.pendingPayoutAmount + ", lastBalanceMovement=" + this.lastBalanceMovement + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Balance)) {
            return false;
        }
        Balance that = (Balance)obj;
        if (!this.currencyCode.equals(that.currencyCode)) {
            return false;
        }
        if (!this.balance.equals(that.balance)) {
            return false;
        }
        if (!this.availableBalance.equals(that.availableBalance)) {
            return false;
        }
        if (!this.pendingSettlementAmount.equals(that.pendingSettlementAmount)) {
            return false;
        }
        if (!this.pendingPayoutAmount.equals(that.pendingPayoutAmount)) {
            return false;
        }
        return this.lastBalanceMovement.equals(that.lastBalanceMovement);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CurrencyCode currencyCode = null;
        private BigDecimal balance = null;
        private BigDecimal availableBalance = null;
        private BigDecimal pendingSettlementAmount = null;
        private BigDecimal pendingPayoutAmount = null;
        private OffsetDateTime lastBalanceMovement = null;

        private Builder() {
        }

        public Builder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder balance(BigDecimal balance) {
            this.balance = balance;
            return this;
        }

        public Builder availableBalance(BigDecimal availableBalance) {
            this.availableBalance = availableBalance;
            return this;
        }

        public Builder pendingSettlementAmount(BigDecimal pendingSettlementAmount) {
            this.pendingSettlementAmount = pendingSettlementAmount;
            return this;
        }

        public Builder pendingPayoutAmount(BigDecimal pendingPayoutAmount) {
            this.pendingPayoutAmount = pendingPayoutAmount;
            return this;
        }

        public Builder lastBalanceMovement(OffsetDateTime lastBalanceMovement) {
            this.lastBalanceMovement = lastBalanceMovement;
            return this;
        }

        public Balance build() {
            return new Balance(this);
        }
    }
}

