/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonClass(generateAdapter=false)
public class AccountPayinRequestNetBanking {
    @NotNull
    public final String accountName;
    @NotNull
    public final Optional<String> accountNumber;
    private final int hashCode;
    private final String toString;

    private AccountPayinRequestNetBanking(Builder builder) {
        this.accountName = Objects.requireNonNull(builder.accountName, "Property 'accountName' is required.");
        this.accountNumber = Optional.ofNullable(builder.accountNumber);
        this.hashCode = Objects.hash(this.accountName, this.accountNumber);
        this.toString = "AccountPayinRequestNetBanking(accountName=" + this.accountName + ", accountNumber=" + this.accountNumber + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountPayinRequestNetBanking)) {
            return false;
        }
        AccountPayinRequestNetBanking that = (AccountPayinRequestNetBanking)obj;
        if (!this.accountName.equals(that.accountName)) {
            return false;
        }
        return this.accountNumber.equals(that.accountNumber);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String accountName = null;
        private String accountNumber = null;

        private Builder() {
        }

        public Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public AccountPayinRequestNetBanking build() {
            return new AccountPayinRequestNetBanking(this);
        }
    }
}

