/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.json;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.json.VaPayMethodResponseJson;
import tech.carpentum.sdk.payment.model.PaymentInstruction;
import tech.carpentum.sdk.payment.model.VaPayMethodResponse;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/json/VaPayMethodResponseJsonAdapter;", "", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/VaPayMethodResponse;", "json", "Ltech/carpentum/sdk/payment/internal/generated/json/VaPayMethodResponseJson;", "toJson", "model", "payment-client-v2"})
public final class VaPayMethodResponseJsonAdapter {
    @FromJson
    @NotNull
    public final VaPayMethodResponse fromJson(@NotNull VaPayMethodResponseJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        VaPayMethodResponse.Builder builder = VaPayMethodResponse.builder();
        builder.idPayin(json.getIdPayin());
        builder.account(json.getAccount());
        builder.money(json.getMoney());
        builder.reference(json.getReference());
        builder.returnUrl(json.getReturnUrl());
        builder.acceptedAt(json.getAcceptedAt());
        builder.expireAt(json.getExpireAt());
        List<PaymentInstruction> list = json.getPaymentInstructionList();
        builder.paymentInstructionList(list == null ? null : CollectionsKt.toList((Iterable)list));
        VaPayMethodResponse vaPayMethodResponse = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)vaPayMethodResponse, (String)"builder.build()");
        return vaPayMethodResponse;
    }

    @ToJson
    @NotNull
    public final VaPayMethodResponseJson toJson(@NotNull VaPayMethodResponse model) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        VaPayMethodResponseJson json = new VaPayMethodResponseJson();
        json.setIdPayin(model.idPayin);
        json.setAccount(model.account);
        json.setMoney(model.money);
        json.setReference(model.reference);
        json.setReturnUrl(model.returnUrl);
        json.setAcceptedAt(model.acceptedAt);
        json.setExpireAt(model.expireAt);
        VaPayMethodResponseJson vaPayMethodResponseJson = json;
        Collection collection2 = model.paymentInstructionList;
        if (collection2.isEmpty()) {
            VaPayMethodResponseJson vaPayMethodResponseJson2 = vaPayMethodResponseJson;
            boolean bl = false;
            collection = null;
            vaPayMethodResponseJson = vaPayMethodResponseJson2;
        } else {
            collection = collection2;
        }
        vaPayMethodResponseJson.setPaymentInstructionList((List)collection);
        json.setPaymentMethodCode(model.paymentMethodCode.name());
        return json;
    }
}

