/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.json;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.json.VaPayMethodJson;
import tech.carpentum.sdk.payment.model.VaPayMethod;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/json/VaPayMethodJsonAdapter;", "", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/VaPayMethod;", "json", "Ltech/carpentum/sdk/payment/internal/generated/json/VaPayMethodJson;", "toJson", "model", "payment-client-v2"})
public final class VaPayMethodJsonAdapter {
    @FromJson
    @NotNull
    public final VaPayMethod fromJson(@NotNull VaPayMethodJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        VaPayMethod.Builder builder = VaPayMethod.builder();
        builder.account(json.getAccount());
        builder.paymentOperatorCode(json.getPaymentOperatorCode());
        builder.emailAddress(json.getEmailAddress());
        VaPayMethod vaPayMethod = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)vaPayMethod, (String)"builder.build()");
        return vaPayMethod;
    }

    @ToJson
    @NotNull
    public final VaPayMethodJson toJson(@NotNull VaPayMethod model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        VaPayMethodJson json = new VaPayMethodJson();
        json.setAccount(model.account);
        json.setPaymentOperatorCode(model.paymentOperatorCode);
        json.setEmailAddress(model.emailAddress.orElse(null));
        json.setPaymentMethodCode(model.paymentMethodCode.name());
        return json;
    }
}

