/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.json;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.json.AuthTokenRequestJson;
import tech.carpentum.sdk.payment.model.AuthTokenRequest;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/json/AuthTokenRequestJsonAdapter;", "", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/AuthTokenRequest;", "json", "Ltech/carpentum/sdk/payment/internal/generated/json/AuthTokenRequestJson;", "toJson", "model", "payment-client-v2"})
public final class AuthTokenRequestJsonAdapter {
    @FromJson
    @NotNull
    public final AuthTokenRequest fromJson(@NotNull AuthTokenRequestJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        AuthTokenRequest.Builder builder = AuthTokenRequest.builder();
        builder.merchantCode(json.getMerchantCode());
        builder.secret(json.getSecret());
        builder.validitySecs(json.getValiditySecs());
        List<String> list = json.getOperations();
        builder.operations(list == null ? null : CollectionsKt.toList((Iterable)list));
        AuthTokenRequest authTokenRequest = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)authTokenRequest, (String)"builder.build()");
        return authTokenRequest;
    }

    @ToJson
    @NotNull
    public final AuthTokenRequestJson toJson(@NotNull AuthTokenRequest model) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        AuthTokenRequestJson json = new AuthTokenRequestJson();
        json.setMerchantCode(model.merchantCode);
        json.setSecret(model.secret);
        json.setValiditySecs(model.validitySecs.orElse(null));
        AuthTokenRequestJson authTokenRequestJson = json;
        Collection collection2 = model.operations;
        if (collection2.isEmpty()) {
            AuthTokenRequestJson authTokenRequestJson2 = authTokenRequestJson;
            boolean bl = false;
            collection = null;
            authTokenRequestJson = authTokenRequestJson2;
        } else {
            collection = collection2;
        }
        authTokenRequestJson.setOperations((List)collection);
        return json;
    }
}

