/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.EnhancedAuthApi;
import tech.carpentum.sdk.payment.internal.api.PostAuthTokensErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.model.AuthTokenRequest;
import tech.carpentum.sdk.payment.model.AuthTokenResponse;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0002 !B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ(\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001c0\u001b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0007J\"\u0010\u0018\u001a\u00020\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010\u001f\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\n\n\u0002\b\u0010\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00020\t\u00a2\u0006\n\n\u0002\b\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\b\u001a\u00020\t\u00a2\u0006\n\n\u0002\b\u0017\u001a\u0004\b\u0016\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ltech/carpentum/sdk/payment/PaymentContext;", "", "apiBaseUrl", "", "apiVersion", "", "merchantCode", "secret", "defaultTokenValidity", "Ljava/time/Duration;", "defaultCallTimeout", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/time/Duration;Ljava/time/Duration;)V", "getApiBaseUrl", "()Ljava/lang/String;", "getApiVersion", "()I", "apiVersion$1", "authApi", "Ltech/carpentum/sdk/payment/internal/api/EnhancedAuthApi;", "getDefaultCallTimeout", "()Ljava/time/Duration;", "defaultCallTimeout$1", "getDefaultTokenValidity", "defaultTokenValidity$1", "createAuthToken", "Ltech/carpentum/sdk/payment/model/AuthTokenResponse;", "operationsSupplier", "Ljava/util/function/Supplier;", "", "tokenValidity", "operations", "validityInSeconds", "Builder", "Factory", "payment-client-v2"})
public final class PaymentContext {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final String apiBaseUrl;
    private final int apiVersion$1;
    @NotNull
    private final String merchantCode;
    @NotNull
    private final String secret;
    @NotNull
    private final Duration defaultTokenValidity$1;
    @NotNull
    private final Duration defaultCallTimeout$1;
    @NotNull
    private final EnhancedAuthApi authApi;
    @NotNull
    public static final String ENV_TECH_CARPENTUM_SDK_PAYMENT_DOMAIN = "TECH_CARPENTUM_SDK_PAYMENT_DOMAIN";
    @NotNull
    public static final String ENV_TECH_CARPENTUM_SDK_PAYMENT_MERCHANT_CODE = "TECH_CARPENTUM_SDK_PAYMENT_MERCHANT_CODE";
    @NotNull
    public static final String ENV_TECH_CARPENTUM_SDK_PAYMENT_SECRET = "TECH_CARPENTUM_SDK_PAYMENT_SECRET";
    @NotNull
    public static final String ENV_TECH_CARPENTUM_SDK_PAYMENT_CALL_TIMEOUT = "TECH_CARPENTUM_SDK_PAYMENT_CALL_TIMEOUT";
    private static final int apiVersion = 2;
    @NotNull
    private static final String apiBaseUrlPrefix = "https://api.";
    @NotNull
    private static final Duration defaultTokenValidity;
    @NotNull
    private static final Duration defaultCallTimeout;

    private PaymentContext(String apiBaseUrl, int apiVersion, String merchantCode, String secret, Duration defaultTokenValidity, Duration defaultCallTimeout) {
        this.apiBaseUrl = apiBaseUrl;
        this.apiVersion$1 = apiVersion;
        this.merchantCode = merchantCode;
        this.secret = secret;
        this.defaultTokenValidity$1 = defaultTokenValidity;
        this.defaultCallTimeout$1 = defaultCallTimeout;
        this.authApi = new EnhancedAuthApi(this.apiBaseUrl, this.defaultCallTimeout$1);
    }

    @NotNull
    public final String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    public final int getApiVersion() {
        return this.apiVersion$1;
    }

    @NotNull
    public final Duration getDefaultTokenValidity() {
        return this.defaultTokenValidity$1;
    }

    @NotNull
    public final Duration getDefaultCallTimeout() {
        return this.defaultCallTimeout$1;
    }

    private final int validityInSeconds(Duration tokenValidity) {
        Duration duration = tokenValidity;
        if (duration == null) {
            duration = this.defaultTokenValidity$1;
        }
        return (int)duration.getSeconds();
    }

    @JvmOverloads
    @NotNull
    public final AuthTokenResponse createAuthToken(@NotNull List<String> operations, @Nullable Duration tokenValidity) throws ResponseException {
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        int validityInSeconds = this.validityInSeconds(tokenValidity);
        AuthTokenRequest requestBody = AuthTokenRequest.builder().merchantCode(this.merchantCode).secret(this.secret).validitySecs(validityInSeconds).operations(operations).build();
        return (AuthTokenResponse)ResponseExceptionUtils.INSTANCE.wrap(PostAuthTokensErrorExceptionFactory.Companion.getInstance(), (Function0)new Function0<AuthTokenResponse>(this, requestBody){
            final /* synthetic */ PaymentContext this$0;
            final /* synthetic */ AuthTokenRequest $requestBody;
            {
                this.this$0 = $receiver;
                this.$requestBody = $requestBody;
                super(0);
            }

            @NotNull
            public final AuthTokenResponse invoke() {
                EnhancedAuthApi enhancedAuthApi = PaymentContext.access$getAuthApi$p(this.this$0);
                int n = this.this$0.getApiVersion();
                AuthTokenRequest authTokenRequest = this.$requestBody;
                Intrinsics.checkNotNullExpressionValue((Object)authTokenRequest, (String)"requestBody");
                return enhancedAuthApi.createAuthToken(n, authTokenRequest);
            }
        });
    }

    public static /* synthetic */ AuthTokenResponse createAuthToken$default(PaymentContext paymentContext, List list, Duration duration, int n, Object object) throws ResponseException {
        if ((n & 2) != 0) {
            duration = null;
        }
        return paymentContext.createAuthToken(list, duration);
    }

    @JvmOverloads
    @NotNull
    public final AuthTokenResponse createAuthToken(@NotNull Supplier<List<String>> operationsSupplier, @Nullable Duration tokenValidity) throws ResponseException {
        Intrinsics.checkNotNullParameter(operationsSupplier, (String)"operationsSupplier");
        List<String> list = operationsSupplier.get();
        Intrinsics.checkNotNullExpressionValue(list, (String)"operationsSupplier.get()");
        return this.createAuthToken(list, tokenValidity);
    }

    public static /* synthetic */ AuthTokenResponse createAuthToken$default(PaymentContext paymentContext, Supplier supplier, Duration duration, int n, Object object) throws ResponseException {
        if ((n & 2) != 0) {
            duration = null;
        }
        return paymentContext.createAuthToken(supplier, duration);
    }

    @JvmOverloads
    @NotNull
    public final AuthTokenResponse createAuthToken(@NotNull List<String> operations) throws ResponseException {
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        return PaymentContext.createAuthToken$default(this, operations, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final AuthTokenResponse createAuthToken(@NotNull Supplier<List<String>> operationsSupplier) throws ResponseException {
        Intrinsics.checkNotNullParameter(operationsSupplier, (String)"operationsSupplier");
        return PaymentContext.createAuthToken$default(this, operationsSupplier, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Factory.builder();
    }

    public static final /* synthetic */ EnhancedAuthApi access$getAuthApi$p(PaymentContext $this) {
        return $this.authApi;
    }

    public static final /* synthetic */ Duration access$getDefaultTokenValidity$cp() {
        return defaultTokenValidity;
    }

    public /* synthetic */ PaymentContext(String apiBaseUrl, int apiVersion, String merchantCode, String secret, Duration defaultTokenValidity, Duration defaultCallTimeout, DefaultConstructorMarker $constructor_marker) {
        this(apiBaseUrl, apiVersion, merchantCode, secret, defaultTokenValidity, defaultCallTimeout);
    }

    static {
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(1)");
        defaultTokenValidity = duration;
        duration = Duration.ofSeconds(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(30)");
        defaultCallTimeout = duration;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltech/carpentum/sdk/payment/PaymentContext$Factory;", "", "()V", "ENV_TECH_CARPENTUM_SDK_PAYMENT_CALL_TIMEOUT", "", "ENV_TECH_CARPENTUM_SDK_PAYMENT_DOMAIN", "ENV_TECH_CARPENTUM_SDK_PAYMENT_MERCHANT_CODE", "ENV_TECH_CARPENTUM_SDK_PAYMENT_SECRET", "apiBaseUrlPrefix", "apiVersion", "", "defaultCallTimeout", "Ljava/time/Duration;", "defaultTokenValidity", "builder", "Ltech/carpentum/sdk/payment/PaymentContext$Builder;", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder();
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltech/carpentum/sdk/payment/PaymentContext$Builder;", "", "()V", "defaultCallTimeout", "Ljava/time/Duration;", "defaultTokenValidity", "domain", "", "merchantCode", "secret", "build", "Ltech/carpentum/sdk/payment/PaymentContext;", "callTimeout", "tokenValidity", "payment-client-v2"})
    public static final class Builder {
        @Nullable
        private String domain = System.getenv("TECH_CARPENTUM_SDK_PAYMENT_DOMAIN");
        @Nullable
        private String merchantCode = System.getenv("TECH_CARPENTUM_SDK_PAYMENT_MERCHANT_CODE");
        @Nullable
        private String secret = System.getenv("TECH_CARPENTUM_SDK_PAYMENT_SECRET");
        @NotNull
        private Duration defaultTokenValidity = PaymentContext.access$getDefaultTokenValidity$cp();
        @NotNull
        private Duration defaultCallTimeout;

        public Builder() {
            Duration duration = Optional.ofNullable(System.getenv(PaymentContext.ENV_TECH_CARPENTUM_SDK_PAYMENT_CALL_TIMEOUT)).map(Builder::defaultCallTimeout$lambda-0).map(Builder::defaultCallTimeout$lambda-1).orElseGet(Builder::defaultCallTimeout$lambda-2);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNullable(System.getenv\u2026tory.defaultCallTimeout }");
            this.defaultCallTimeout = duration;
        }

        @NotNull
        public final Builder domain(@NotNull String domain) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Builder $this$domain_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$domain_u24lambda_u2d3.domain = domain;
            return builder;
        }

        @NotNull
        public final Builder merchantCode(@NotNull String merchantCode) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)merchantCode, (String)"merchantCode");
            Builder $this$merchantCode_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$merchantCode_u24lambda_u2d4.merchantCode = merchantCode;
            return builder;
        }

        @NotNull
        public final Builder secret(@NotNull String secret) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            Builder $this$secret_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$secret_u24lambda_u2d5.secret = secret;
            return builder;
        }

        @NotNull
        public final Builder defaultTokenValidity(@NotNull Duration tokenValidity) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tokenValidity, (String)"tokenValidity");
            Builder $this$defaultTokenValidity_u24lambda_u2d6 = builder = this;
            boolean bl = false;
            $this$defaultTokenValidity_u24lambda_u2d6.defaultTokenValidity = tokenValidity;
            return builder;
        }

        @NotNull
        public final Builder defaultCallTimeout(@NotNull Duration callTimeout) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)callTimeout, (String)"callTimeout");
            Builder $this$defaultCallTimeout_u24lambda_u2d7 = builder = this;
            boolean bl = false;
            $this$defaultCallTimeout_u24lambda_u2d7.defaultCallTimeout = callTimeout;
            return builder;
        }

        @NotNull
        public final PaymentContext build() {
            String string = this.domain;
            if (string == null) {
                String string2 = PaymentContext.apiBaseUrlPrefix;
                boolean $i$a$-requireNotNull-PaymentContext$Builder$build$42 = false;
                String string3 = string2;
                String $i$a$-requireNotNull-PaymentContext$Builder$build$42 = "Property 'domain' is mandatory.";
                throw new IllegalArgumentException($i$a$-requireNotNull-PaymentContext$Builder$build$42.toString());
            }
            String string4 = Intrinsics.stringPlus((String)PaymentContext.apiBaseUrlPrefix, (Object)string);
            String string5 = this.merchantCode;
            if (string5 == null) {
                int n = 2;
                String string6 = string4;
                boolean $i$a$-requireNotNull-PaymentContext$Builder$build$52 = false;
                String string7 = "Property 'merchantCode' is mandatory.";
                String string8 = string6;
                int n2 = n;
                String $i$a$-requireNotNull-PaymentContext$Builder$build$52 = string7;
                throw new IllegalArgumentException($i$a$-requireNotNull-PaymentContext$Builder$build$52.toString());
            }
            String string9 = this.secret;
            if (string9 == null) {
                String string10 = string5;
                int n = 2;
                String string11 = string4;
                boolean bl = false;
                String string12 = "Property 'secret' is mandatory.";
                String string13 = string11;
                int n3 = n;
                String string14 = string10;
                String string15 = string12;
                throw new IllegalArgumentException(string15.toString());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            Duration duration = this.defaultCallTimeout;
            Duration duration2 = this.defaultTokenValidity;
            String string16 = string9;
            String string17 = string5;
            int n = 2;
            String string18 = string4;
            return new PaymentContext(string18, n, string17, string16, duration2, duration, defaultConstructorMarker);
        }

        private static final Long defaultCallTimeout$lambda-0(String it) {
            long l;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                l = Long.parseLong(it);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Environment variable TECH_CARPENTUM_SDK_PAYMENT_CALL_TIMEOUT wrong number format: ", (Object)it));
            }
            return l;
        }

        private static final Duration defaultCallTimeout$lambda-1(Long it) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            return Duration.ofSeconds(it);
        }

        private static final Duration defaultCallTimeout$lambda-2() {
            return defaultCallTimeout;
        }
    }
}

